/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.api.connection;

/**
 * Default implementation of a reconnection manager. Nothing is taken account during reconnection.
 * 
 * @since 1.8.0
 */
public class DefaultReconnectionManagerProvider implements JmsReconnectionManager {

  @Override
  public boolean blockedOperations() {
    return true;
  }

  @Override
  public void blockOperations() {}

  @Override
  public void unblockOperations() {}

  @Override
  public boolean isReconnecting() {
    return false;
  }

  @Override
  public void reconnecting() {}

  @Override
  public void finishReconnecting() {}
}
