/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.api.exception;

import org.mule.jms.commons.api.destination.DestinationType;
import org.mule.jms.commons.api.message.JmsMessageBuilder;
import org.mule.jms.commons.internal.publish.JmsPublishParameters;
import org.mule.jms.commons.internal.config.DefaultJmsConfig;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.operation.JmsPublish;
import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

import java.util.HashSet;
import java.util.Set;

import static java.util.Collections.unmodifiableSet;
import static org.mule.jms.commons.api.exception.JmsError.DESTINATION_NOT_FOUND;
import static org.mule.jms.commons.api.exception.JmsError.ILLEGAL_BODY;
import static org.mule.jms.commons.api.exception.JmsError.PUBLISHING;
import static org.mule.jms.commons.api.exception.JmsError.SECURITY;

/**
 * Errors that can be thrown in the
 * {@link JmsPublish#publish(DefaultJmsConfig, JmsTransactionalConnection, String, DestinationType, JmsMessageBuilder, JmsPublishParameters)}
 * operation operation.
 *
 * @since 1.0
 */
public class JmsPublisherErrorTypeProvider implements ErrorTypeProvider {

  @Override
  public Set<ErrorTypeDefinition> getErrorTypes() {
    Set<ErrorTypeDefinition> tmpSet = new HashSet<>();
    tmpSet.add(PUBLISHING);
    tmpSet.add(ILLEGAL_BODY);
    tmpSet.add(DESTINATION_NOT_FOUND);
    tmpSet.add(SECURITY);
    return unmodifiableSet(tmpSet);

  }
}

