/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.api.message;

import org.mule.jms.commons.api.config.DefaultJmsProducerConfig;
import org.mule.jms.commons.api.destination.JmsDestination;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;

import java.util.Map;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;

public interface JmsMessageBuilder<D extends JmsDestination> {

  /**
   * Creates a {@link Message} based on the provided configurations
   *
   * @param jmsSupport                  the {@link JmsSupport} used to create the JMSReplyTo {@link Destination}
   * @param outboundCorrelationStrategy the correlationId handling strategy
   * @param correlationInfo             the correlation information for the current message
   * @param session                     the current {@link Session}
   * @param config                      the current {@link DefaultJmsProducerConfig}
   * @return the {@link Message} created by the user
   * @throws JMSException if an error occurs
   */
  Message build(JmsSupport jmsSupport, OutboundCorrelationStrategy outboundCorrelationStrategy,
                CorrelationInfo correlationInfo,
                Session session, JmsConfig config)
      throws JMSException;

  TypedValue<Object> getBody();

  boolean isSendContentType();

  String getOutboundContentType();

  Map<String, Object> getProperties();

  String getJmsType();

  String getCorrelationId();

  JmsxProperties getJmsxProperties();

  JmsDestination getReplyTo();

  boolean isSendEncoding();

  String getOutboundEncoding();
}
