/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.common;

import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

import javax.jms.CompletionListener;
import javax.jms.Message;

public class JmsPublisherCompletitionListener implements CompletionListener {

  private CompletionCallback<Void, Void> callback;

  public JmsPublisherCompletitionListener(CompletionCallback<Void, Void> callback) {
    this.callback = callback;
  }

  @Override
  public void onCompletion(Message message) {
    callback.success(Result.<Void, Void>builder().build());
  }

  @Override
  public void onException(Message message, Exception exception) {
    callback.error(exception);
  }
}
