/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.connection.param;

/**
 * Configuration for an XA pool
 *
 * @since 1.5.0
 */
public interface XaPoolParameters {

  /**
   * @return The pool min size
   */
  int getMinPoolSize();

  /**
   * @return The pool max size
   */
  int getMaxPoolSize();

  /**
   * @return the time in seconds that a connection can remain idle before being eligible for eviction
   */
  int getMaxIdleTime();
}
