/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.connection.provider;

import static org.mule.jms.commons.internal.config.InternalAckMode.AUTO;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.slf4j.Logger;
import org.springframework.jms.JmsException;
import java.util.concurrent.Callable;

import static org.mule.runtime.api.connection.ConnectionValidationResult.failure;
import static org.mule.runtime.api.connection.ConnectionValidationResult.success;
import static org.mule.jms.commons.internal.common.JmsCommons.closeQuietly;
import static org.slf4j.LoggerFactory.getLogger;

public class JmsConnectionValidationTask implements Callable<ConnectionValidationResult> {

  private static final Logger LOGGER = getLogger(JmsConnectionValidationTask.class);

  JmsConnection connection;

  public JmsConnectionValidationTask(JmsConnection connection) {
    this.connection = connection;
  }

  @Override
  public ConnectionValidationResult call() throws Exception {
    JmsSession session = connection.createSession(AUTO, false);
    try {
      session.get().createMessage();
    } catch (JmsException e) {
      if (LOGGER.isDebugEnabled()) {
        LOGGER.error("Error validating connection ", e);
      }
      return failure("Invalid connection provided: Connection could not be started.", e);
    } finally {
      closeQuietly(session);
    }
    return success();
  }
}


