/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.consume;

import org.mule.jms.commons.internal.config.JmsAckMode;

import java.util.concurrent.TimeUnit;

public interface JmsConsumeParameters {

  JmsAckMode getAckMode();

  long getMaximumWait();

  TimeUnit getMaximumWaitUnit();

  String getInboundContentType();

  String getInboundEncoding();
}
