/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.api.connection;

/**
 * The JmsReconnectionManager is responsible for managing and orchestrating the different steps in the reconnection process. It
 * provides information regarding the operations that are being performed and whether certain operations are available.
 *
 * @since 1.8.0
 */
public interface JmsReconnectionManager {

  /**
   * Indicates whether operations can be performed.
   * 
   * @return whether the reconnection can be performed.
   */
  boolean blockedOperations();

  /**
   * Blocks operations. After unblocking the manager will indicate that the reconnection cannot be performed.
   */
  void blockOperations();

  /**
   * Unblocks operations. After unblocking the manager will indicate that the reconnection can be performed.
   */
  void unblockOperations();

  /**
   * Indicates that a reconnection is ongoing.
   * 
   * @return whether a reconnection is ongoing.
   */
  boolean isReconnecting();

  /**
   * Informs the manager that a reconnection is ongoing.
   */
  void reconnecting();

  /**
   * Informs the manager that a reconnection is finished.
   */
  void finishReconnecting();
}
