/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.api.lock;

import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.lock.DefaultJmsListenerLockFactory;
import org.mule.jms.commons.internal.source.JmsListenerLock;

/**
 * Factory for instances of {@link JmsListenerLock}
 *
 * @since 1.2.0
 */
public interface JmsListenerLockFactory {

  /**
   * @return a new default instance
   */
  static JmsListenerLockFactory newDefault() {
    return new DefaultJmsListenerLockFactory();
  }

  /**
   * Creates a new instance for the given {@code resolvedAckMode}
   *
   * @param resolvedAckMode the ack mode
   * @return a new instance
   * @throws {@link IllegalStateException} if {@code this} factory has been disabled through {@link #setEnabled(boolean)}
   */
  JmsListenerLock createLock(InternalAckMode resolvedAckMode);

  /**
   * Toggles the enable state of {@code this} instance. This is useful for stop/reconnection cases in which we want to keep
   * messages from being dispatched to the flow.
   *
   * @param enabled the new state
   */
  void setEnabled(boolean enabled);

}
