/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.message;

import static org.mule.runtime.api.util.Preconditions.checkArgument;

import org.mule.jms.commons.api.message.DefaultJmsAttributes;
import org.mule.jms.commons.api.message.JmsAttributes;
import org.mule.jms.commons.api.message.JmsHeaders;
import org.mule.jms.commons.api.message.JmsMessageProperties;

import java.util.Map;

/**
 * Default {@link JmsAttributesBuilder} implementation
 *
 * @since 1.0.1
 */
public class DefaultJmsAttributesBuilder implements JmsAttributesBuilder {

  private JmsMessageProperties properties;
  private JmsHeaders headers;
  private String ackId;

  @Override
  public DefaultJmsAttributesBuilder withProperties(Map<String, Object> properties) {
    this.properties = new JmsMessageProperties(properties);
    return this;
  }

  @Override
  public DefaultJmsAttributesBuilder withHeaders(JmsHeaders headers) {
    this.headers = headers;
    return this;
  }

  @Override
  public DefaultJmsAttributesBuilder withAckId(String ackId) {
    this.ackId = ackId;
    return this;
  }

  @Override
  public JmsAttributes build() {
    checkArgument(properties != null, "No JmsMessageProperties were provided, but they are required for the JmsAttributes");
    checkArgument(headers != null, "No JmsHeaders were provided, but they are required for the JmsAttributes");
    return new DefaultJmsAttributes(properties, headers, ackId);
  }
}
