/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.api.destination;

import org.apache.commons.lang3.StringUtils;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="topic-consumer")
public class TopicConsumer
implements ConsumerType,
Initialisable {
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Allows an application to receive all the messages published on a topic, including the ones published when there is no consumer associated with it")
    private boolean durable;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Only for JMS 2.0: Allows the processing of messages from a topic subscription by multiple threads, connections or JVMs")
    private boolean shared;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Specifies that messages published to the topic by its own connection must not be added to the subscription")
    private boolean noLocal;
    @Parameter
    @Optional
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The name to be used for the subscription")
    private String subscriptionName;

    @Override
    public boolean topic() {
        return true;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isShared() {
        return this.shared;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void initialise() throws InitialisationException {
        if (!StringUtils.isBlank((CharSequence)this.subscriptionName)) {
            Preconditions.checkArgument((this.isShared() || this.isDurable() ? 1 : 0) != 0, (String)"A [subscriptionName] was provided, but the subscription is neither [durable] nor [shared]");
        } else {
            Preconditions.checkArgument((!this.isShared() && !this.isDurable() ? 1 : 0) != 0, (String)"No [subscriptionName] was provided, but one is required to create a [durable] or [shared] subscriber");
        }
        Preconditions.checkArgument((!this.isShared() || !this.isNoLocal() ? 1 : 0) != 0, (String)"A [shared] topic consumer can't be [noLocal]");
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }
}

