/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.operation;

import java.io.EOFException;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import org.mule.jms.commons.api.destination.DestinationTypeDescriptor;
import org.mule.jms.commons.api.exception.JmsExtensionException;
import org.mule.jms.commons.api.exception.JmsPublishException;
import org.mule.jms.commons.api.exception.JmsPublisherErrorTypeProvider;
import org.mule.jms.commons.api.exception.JmsSecurityException;
import org.mule.jms.commons.api.message.JmsMessageBuilder;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.common.JmsPublisherCompletionListener;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.publish.JmsMessageProducer;
import org.mule.jms.commons.internal.publish.PublishConnectionExceptionErrorCodes;
import org.mule.jms.commons.internal.publish.PublisherParameters;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsPublish
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsPublish.class);
    private static final Result<Void, Void> VOID_RESULT = Result.builder().build();
    private static final String IBM_CONNECTION_CLOSED_CODE = "JMSCC0008";
    private static final String LOST_SERVER_EXCEPTION = "LostServerException";
    private static final String NETWORK_CONNECTION_TO_SERVER_WAS_LOST = "Network connection to server was lost.";
    private static final String ACTIVE_MQ_NOT_CONNECTED_EXCEPTION = "ActiveMQNotConnectedException";
    private static final String CONNECTION_IS_DESTROYED = "Connection is destroyed";
    private static final String JMS_EXCEPTION_NAME = "javax.jms.JMSException";
    private JmsSessionManager jmsSessionManager;
    private Scheduler scheduler;

    public JmsPublish(JmsSessionManager jmsSessionManager, SchedulerService schedulerService) {
        this.jmsSessionManager = jmsSessionManager;
        this.scheduler = schedulerService.ioScheduler();
    }

    @Throws(value={JmsPublisherErrorTypeProvider.class})
    public void publish(@Config JmsConfig config, @Connection JmsTransactionalConnection connection, @Summary(value="The name of the Destination where the Message should be sent") String destination, @Optional(defaultValue="QUEUE") @Summary(value="The type of the Destination") DestinationTypeDescriptor destinationType, @Summary(value="A builder for the message that will be published") @ParameterGroup(name="Message", showInDsl=true) JmsMessageBuilder messageBuilder, @ParameterGroup(name="Publish Configuration") PublisherParameters overrides, OperationTransactionalAction transactionalAction, @ConfigOverride OutboundCorrelationStrategy sendCorrelationId, CorrelationInfo correlationInfo, CompletionCallback<Void, Void> completionCallback) throws JmsExtensionException {
        JmsSession session = null;
        JmsMessageProducer producer = null;
        boolean isPartOfCurrentTx = false;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Begin [publish] on " + JmsCommons.getDestinationType(destinationType) + ": [" + destination + "]");
            }
            session = JmsCommons.createJmsSession(connection, InternalAckMode.AUTO, destinationType.isTopic(), this.jmsSessionManager, transactionalAction);
            isPartOfCurrentTx = JmsCommons.isPartOfCurrentTx(session, connection, this.jmsSessionManager);
            Message message = messageBuilder.build(connection.getJmsSupport(), sendCorrelationId, correlationInfo, session.get(), config);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Message built, sending message to the %s: [%s] using session [%s]", JmsCommons.getDestinationType(destinationType), destination, session.get()));
            }
            Destination jmsDestination = connection.getJmsSupport().createDestination(session.get(), destination, destinationType.isTopic(), config);
            producer = connection.createProducer(session, jmsDestination, destinationType.isTopic());
            if (isPartOfCurrentTx) {
                this.publishTransactionally(session, producer, message, overrides, completionCallback);
            } else {
                producer.publish(message, overrides, new JmsPublisherCompletionListener(completionCallback, session, producer, destination, JmsCommons.getDestinationType(destinationType), false, this.scheduler));
            }
        }
        catch (JMSSecurityException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found JMSSecurityException: {}", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e);
            }
            String msg = String.format("A security error occurred while sending a message to the %s: [%s]: %s", JmsCommons.getDestinationType(destinationType), destination, e.getMessage());
            completionCallback.error((Throwable)((Object)new JmsSecurityException(msg, (Exception)((Object)e))));
            JmsCommons.releaseResources(session, isPartOfCurrentTx, producer);
        }
        catch (IllegalStateException e) {
            boolean isConnectionError;
            boolean bl = isConnectionError = session == null;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found IllegalStateException: {}", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e);
            }
            if ("ConnectionClosedException".equals(((Object)((Object)e)).getClass().getSimpleName()) || e.getMessage().startsWith(IBM_CONNECTION_CLOSED_CODE)) {
                isConnectionError = true;
            }
            String msg = String.format((isConnectionError ? "A connection error" : "An error") + " occurred while sending a message to the %s: [%s]: %s", JmsCommons.getDestinationType(destinationType), destination, e.getMessage());
            completionCallback.error((Throwable)(isConnectionError ? new ConnectionException((Throwable)e, (Object)connection) : new JmsPublishException(msg, e)));
            JmsCommons.releaseResources(session, isPartOfCurrentTx, producer);
        }
        catch (JmsPublishException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found JMSPublishException: {}", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e);
            }
            completionCallback.error((Throwable)((Object)e));
            JmsCommons.releaseResources(session, isPartOfCurrentTx, producer);
        }
        catch (Throwable e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found Throwable: {}", (Object)e.getClass().getSimpleName(), (Object)e);
            }
            String msg = String.format("[publish] An error occurred while sending a message to the %s: [%s]: %s", JmsCommons.getDestinationType(destinationType), destination, e.getMessage());
            if (e.getClass().toString().contains("DetailedJMSException") && PublishConnectionExceptionErrorCodes.DETAILED_JMS_EXCEPTION_CODES.contains(((JMSException)e).getErrorCode())) {
                LOGGER.error("Caught JMSException/DetailedJMSException  ", e);
                JMSException ex = (JMSException)e;
                String errCode = ex.getErrorCode();
                String msg2 = String.format("class: %s, errCode: %s, errMsg:%s, linkedEx: %s", ((Object)((Object)ex)).getClass().toString(), errCode, ex.getMessage(), ex.getLinkedException());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[publish-1] Triggering reconnection. msg2: " + msg2);
                }
                completionCallback.error((Throwable)new ConnectionException(e, (Object)connection));
            } else if (e.getCause() instanceof EOFException || e.getClass().getName().equals("ConnectionClosedException") || e.getClass().getName().equals("org.apache.activemq.ConnectionFailedException")) {
                LOGGER.error("Caught EOFException. Throwing a new ConnectionException", e);
                completionCallback.error((Throwable)new ConnectionException(e, (Object)connection));
            } else if (e.getCause() != null && (e.getCause().toString().contains(ACTIVE_MQ_NOT_CONNECTED_EXCEPTION) || e.getCause().toString().contains(JMS_EXCEPTION_NAME)) && e.getMessage().contains(CONNECTION_IS_DESTROYED)) {
                LOGGER.error("Caught JMSException/ActiveMQNotConnectedException  ", e);
                completionCallback.error((Throwable)new ConnectionException(e, (Object)connection));
            } else if (JmsPublish.isConnectionBrokenException(e)) {
                String msg3 = String.format("class: %s, errMsg:%s", e.getClass().toString(), e.getMessage());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[publish-2] Triggering reconnection. msg3: " + msg3);
                }
                completionCallback.error((Throwable)new ConnectionException(e, (Object)connection));
            } else if (e.getClass().toString().contains(LOST_SERVER_EXCEPTION) || e.getMessage().contains(NETWORK_CONNECTION_TO_SERVER_WAS_LOST)) {
                LOGGER.error("Caught weblogic LostServerException  ", e);
                completionCallback.error((Throwable)new ConnectionException("Weblogic lost server connection error", e));
            } else {
                LOGGER.error("Caught an Exception", e);
                if (e instanceof JMSException) {
                    JMSException ex = (JMSException)e;
                    String errCode = ex.getErrorCode();
                    String msg2 = String.format("class: %s, errCode: %s, errMsg:%s, linkedEx: %s", ((Object)((Object)ex)).getClass().toString(), errCode, ex.getMessage(), ex.getLinkedException());
                    if (errCode != null && errCode.equals("JMSWMQ2007")) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("[publish-3] Triggering reconnection. msg2: " + msg2);
                        }
                        completionCallback.error((Throwable)new ConnectionException(msg, e));
                    } else {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("[publish-4] Not triggering reconnection. msg2: " + msg2);
                        }
                        completionCallback.error((Throwable)((Object)new JmsPublishException(msg, e)));
                    }
                } else {
                    completionCallback.error((Throwable)((Object)new JmsPublishException(msg, e)));
                }
            }
            JmsCommons.releaseResources(session, isPartOfCurrentTx, producer);
        }
    }

    private void publishTransactionally(JmsSession session, JmsMessageProducer producer, Message message, PublisherParameters overrides, CompletionCallback<Void, Void> completionCallback) throws JMSException {
        producer.publish(message, overrides);
        completionCallback.success(VOID_RESULT);
        JmsCommons.releaseResources(session, true, producer);
    }

    public static boolean isConnectionBrokenException(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        while (throwable != null) {
            if (throwable.getClass().getName().startsWith("com.ibm") && throwable.getMessage() != null && (throwable.getMessage().toUpperCase().contains("REASON '2009'") || throwable.getMessage().toUpperCase().contains("RC=2009"))) {
                LOGGER.error("Caught IBM connection broken exception");
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }
}

