/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.endpoint;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.ResourceException;
import javax.resource.spi.UnavailableException;
import org.springframework.jca.endpoint.AbstractMessageEndpointFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JmsMessageEndpointFactory
extends AbstractMessageEndpointFactory {
    @Nullable
    private MessageListener messageListener;

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    protected MessageListener getMessageListener() {
        Assert.state(this.messageListener != null, "No MessageListener set");
        return this.messageListener;
    }

    @Override
    protected AbstractMessageEndpointFactory.AbstractMessageEndpoint createEndpointInternal() throws UnavailableException {
        return new JmsMessageEndpoint();
    }

    public static class JmsResourceException
    extends RuntimeException {
        public JmsResourceException(ResourceException cause) {
            super((Throwable)cause);
        }
    }

    private class JmsMessageEndpoint
    extends AbstractMessageEndpointFactory.AbstractMessageEndpoint
    implements MessageListener {
        private JmsMessageEndpoint() {
            super(JmsMessageEndpointFactory.this);
        }

        public void onMessage(Message message) {
            boolean applyDeliveryCalls;
            Throwable endpointEx = null;
            boolean bl = applyDeliveryCalls = !this.hasBeforeDeliveryBeenCalled();
            if (applyDeliveryCalls) {
                try {
                    this.beforeDelivery(null);
                }
                catch (ResourceException ex) {
                    throw new JmsResourceException(ex);
                }
            }
            try {
                JmsMessageEndpointFactory.this.getMessageListener().onMessage(message);
            }
            catch (Error | RuntimeException ex) {
                endpointEx = ex;
                this.onEndpointException(ex);
                throw ex;
            }
            finally {
                block14: {
                    if (applyDeliveryCalls) {
                        try {
                            this.afterDelivery();
                        }
                        catch (ResourceException ex) {
                            if (endpointEx != null) break block14;
                            throw new JmsResourceException(ex);
                        }
                    }
                }
            }
        }

        @Override
        protected ClassLoader getEndpointClassLoader() {
            return JmsMessageEndpointFactory.this.getMessageListener().getClass().getClassLoader();
        }
    }
}

