/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.common;

import javax.jms.CompletionListener;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import org.mule.jms.commons.api.exception.JmsExtensionException;
import org.mule.jms.commons.api.exception.JmsPublishException;
import org.mule.jms.commons.api.exception.JmsSecurityException;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.publish.JmsMessageProducer;
import org.mule.jms.commons.internal.publish.PublishConnectionExceptionErrorCodes;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsPublisherCompletionListener
implements CompletionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsPublisherCompletionListener.class);
    private static final Result<Void, Void> VOID_RESULT = Result.builder().build();
    private CompletionCallback<Void, Void> callback;
    private final JmsSession session;
    private final JmsMessageProducer producer;
    private final String destination;
    private final String destinationType;
    private boolean isPartOfCurrentTx;
    private Scheduler scheduler;

    public JmsPublisherCompletionListener(CompletionCallback<Void, Void> callback, JmsSession session, JmsMessageProducer producer, String destination, String destinationType, boolean isPartOfCurrentTx, Scheduler scheduler) {
        this.callback = callback;
        this.session = session;
        this.producer = producer;
        this.destination = destination;
        this.destinationType = destinationType;
        this.isPartOfCurrentTx = isPartOfCurrentTx;
        this.scheduler = scheduler;
    }

    public void onCompletion(Message message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Finished [publish] to the %s: [%s] using session [%s]", this.destinationType, this.destination, this.session.get()));
        }
        this.scheduler.submit(() -> JmsCommons.releaseResources(this.session, this.isPartOfCurrentTx, this.producer));
        this.callback.success(VOID_RESULT);
    }

    public void onException(Message message, Exception exception) {
        Object err = exception;
        if (exception instanceof JMSSecurityException) {
            String msg = String.format("A security error occurred while sending a message to the %s: [%s]: %s", this.destinationType, this.destination, exception.getMessage());
            err = new JmsSecurityException(msg, exception);
        } else if (exception instanceof JmsExtensionException) {
            err = exception;
        } else {
            String msg = String.format("[publish-onException] An error occurred while sending a message to the %s: [%s]: %s", this.destinationType, this.destination, exception.getMessage());
            err = new JmsPublishException(msg, (Throwable)exception);
            if (exception instanceof JMSException) {
                JMSException ex = (JMSException)((Object)exception);
                String errCode = ex.getErrorCode();
                String errMsg = String.format("class: %s, errCode: %s, errMsg:%s, linkedEx: %s", ((Object)((Object)ex)).getClass().toString(), errCode, ex.getMessage(), ex.getLinkedException());
                if (errCode != null && PublishConnectionExceptionErrorCodes.DETAILED_JMS_EXCEPTION_CODES.contains(errCode)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("[publish-onException] Triggering reconnection. errMsg: " + errMsg);
                    }
                    err = new ConnectionException(msg, (Throwable)exception);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[publish-onException] Not triggering reconnection. errMsg: " + errMsg);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Failed to [publish] to the %s: [%s] using session [%s]", this.destinationType, this.destination, this.session.get(), err));
            }
        }
        this.scheduler.submit(() -> JmsCommons.releaseResources(this.session, this.isPartOfCurrentTx, this.producer));
        this.callback.error((Throwable)err);
    }
}

