/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection.exception;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeJmsExceptionListener
implements ExceptionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeJmsExceptionListener.class);
    private List<ExceptionListener> exceptionListenerList = new CopyOnWriteArrayList<ExceptionListener>();

    public void onException(JMSException exception) {
        int exceptionListenersCount = this.exceptionListenerList.size();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Length of exceptionListenerList: {}", (Object)exceptionListenersCount);
        }
        this.exceptionListenerList.forEach(listener -> listener.onException(exception));
    }

    public void registerExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListenerList.add(exceptionListener);
    }

    public void removeExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListenerList.remove(exceptionListener);
    }
}

