/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.api.exception;

import static java.util.Collections.unmodifiableSet;
import static org.mule.jms.commons.api.exception.JmsError.SESSION_RECOVER;
import org.mule.jms.commons.internal.operation.JmsAcknowledge;
import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

import java.util.HashSet;
import java.util.Set;

/**
 * Errors that can be thrown in the {@link JmsAcknowledge#recoverSession(String)} operation.
 *
 * @since 1.0
 */
public class JmsSessionRecoverErrorTypeProvider implements ErrorTypeProvider {

  @Override
  public Set<ErrorTypeDefinition> getErrorTypes() {
    Set<ErrorTypeDefinition> tmpSet = new HashSet<>();
    tmpSet.add(SESSION_RECOVER);
    return unmodifiableSet(tmpSet);
  }
}

