/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection.provider;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.mule.jms.commons.api.connection.DefaultReconnectionManagerProvider;
import org.mule.jms.commons.api.connection.JmsReconnectionManager;
import org.mule.jms.commons.api.connection.JmsSpecification;
import org.mule.jms.commons.api.connection.caching.CachingStrategy;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.connection.IBMJmsCachingConnectionFactory;
import org.mule.jms.commons.internal.connection.JmsCachingConnectionFactory;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.XaJmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.exception.CompositeJmsExceptionListener;
import org.mule.jms.commons.internal.connection.param.GenericConnectionParameters;
import org.mule.jms.commons.internal.connection.param.XaPoolParameters;
import org.mule.jms.commons.internal.connection.provider.ConnectionFactoryDecorator;
import org.mule.jms.commons.internal.connection.provider.ConnectionFactoryDecoratorFactory;
import org.mule.jms.commons.internal.connection.provider.JmsConnectionValidationTask;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.jms.commons.internal.support.JmsSupportFactory;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConnectionProvider
implements CachedConnectionProvider<JmsTransactionalConnection>,
Initialisable,
Disposable {
    private static final int VALIDATION_TIMEOUT = 10;
    private static final String VALIDATION_THREAD_NAME_PATTERN = "connectionValidationThread-%d";
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConnectionProvider.class);
    private final JmsSessionManager jmsSessionManager;
    private final JmsSpecification specification;
    private final GenericConnectionParameters connectionParameters;
    private final XaPoolParameters xaPoolParameters;
    private final CachingStrategy cachingStrategy;
    private final boolean isIBM;
    private XaJmsTransactionalConnection xaJmsTransactionalConnection;
    private final ConnectionFactoryDecorator factoryDecorator;
    private final Supplier<ConnectionFactory> connectionFactorySupplier;
    private final boolean isXa;
    private final JmsSupportFactory jmsSupportFactory;
    private final String configName;
    private JmsReconnectionManager reconnectionManager;
    private CompositeJmsExceptionListener exceptionListener = new CompositeJmsExceptionListener();
    private final AtomicBoolean disconnecting = new AtomicBoolean(false);
    private JmsSupport jmsSupport;
    private ConnectionFactory jmsConnectionFactory;
    private boolean isCacheEnabled = false;
    private Optional<Runnable> setupSsl;

    public JmsConnectionProvider(JmsSessionManager jmsSessionManager, Supplier<ConnectionFactory> connectionFactorySupplier, JmsSpecification specification, GenericConnectionParameters connectionParameters, XaPoolParameters xaPoolParameters, CachingStrategy cachingStrategy, boolean isXa, JmsSupportFactory jmsSupportFactory, ConnectionFactoryDecoratorFactory factoryDecoratorFactory, String configName, boolean isIBM, JmsReconnectionManager reconnectionManager, Optional<Runnable> setupSsl) throws InitialisationException {
        this.setupSsl = setupSsl;
        this.jmsSessionManager = jmsSessionManager;
        this.connectionFactorySupplier = connectionFactorySupplier;
        this.specification = specification;
        this.connectionParameters = connectionParameters;
        this.xaPoolParameters = xaPoolParameters;
        this.cachingStrategy = cachingStrategy;
        this.isXa = isXa;
        this.jmsSupportFactory = jmsSupportFactory;
        this.factoryDecorator = factoryDecoratorFactory.create();
        this.configName = configName;
        this.isIBM = isIBM;
        this.reconnectionManager = reconnectionManager;
        this.initialise();
    }

    public JmsConnectionProvider(JmsSessionManager jmsSessionManager, Supplier<ConnectionFactory> connectionFactorySupplier, JmsSpecification specification, GenericConnectionParameters connectionParameters, XaPoolParameters xaPoolParameters, CachingStrategy cachingStrategy, boolean isXa, JmsSupportFactory jmsSupportFactory, ConnectionFactoryDecoratorFactory factoryDecoratorFactory, String configName, boolean isIBM, JmsReconnectionManager reconnectionManager) throws InitialisationException {
        this(jmsSessionManager, connectionFactorySupplier, specification, connectionParameters, xaPoolParameters, cachingStrategy, isXa, jmsSupportFactory, factoryDecoratorFactory, configName, isIBM, reconnectionManager, Optional.empty());
    }

    public JmsConnectionProvider(JmsSessionManager jmsSessionManager, Supplier<ConnectionFactory> connectionFactorySupplier, JmsSpecification specification, GenericConnectionParameters connectionParameters, XaPoolParameters xaPoolParameters, CachingStrategy cachingStrategy, boolean isXa, JmsSupportFactory jmsSupportFactory, ConnectionFactoryDecoratorFactory factoryDecoratorFactory, String configName, boolean isIBM, Optional<Runnable> setupSsl) throws InitialisationException {
        this(jmsSessionManager, connectionFactorySupplier, specification, connectionParameters, xaPoolParameters, cachingStrategy, isXa, jmsSupportFactory, factoryDecoratorFactory, configName, isIBM, new DefaultReconnectionManagerProvider(), setupSsl);
    }

    public JmsConnectionProvider(JmsSessionManager jmsSessionManager, Supplier<ConnectionFactory> connectionFactorySupplier, JmsSpecification specification, GenericConnectionParameters connectionParameters, XaPoolParameters xaPoolParameters, CachingStrategy cachingStrategy, boolean isXa, JmsSupportFactory jmsSupportFactory, ConnectionFactoryDecoratorFactory factoryDecoratorFactory, String configName, Optional<Runnable> setupSsl) throws InitialisationException {
        this(jmsSessionManager, connectionFactorySupplier, specification, connectionParameters, xaPoolParameters, cachingStrategy, isXa, jmsSupportFactory, factoryDecoratorFactory, configName, false, setupSsl);
    }

    public JmsConnectionProvider(JmsSessionManager jmsSessionManager, Supplier<ConnectionFactory> connectionFactorySupplier, JmsSpecification specification, GenericConnectionParameters connectionParameters, XaPoolParameters xaPoolParameters, CachingStrategy cachingStrategy, boolean isXa, JmsSupportFactory jmsSupportFactory, ConnectionFactoryDecoratorFactory factoryDecoratorFactory, String configName) throws InitialisationException {
        this(jmsSessionManager, connectionFactorySupplier, specification, connectionParameters, xaPoolParameters, cachingStrategy, isXa, jmsSupportFactory, factoryDecoratorFactory, configName, false, Optional.empty());
    }

    public ConnectionFactory getConnectionFactory() throws Exception {
        ConnectionFactory connectionFactory = this.connectionFactorySupplier.get();
        return this.factoryDecorator.decorate(connectionFactory, this.configName, true, this.connectionParameters, this.xaPoolParameters, this.exceptionListener);
    }

    public void initialise() throws InitialisationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Executing initialise for [%s]", this.getClass().getName()));
        }
        try {
            this.createJmsSupport();
            this.initialiseConnectionFactory();
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Failed to initialise [%s]: ", this.getClass().getName()), (Throwable)e);
            }
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public JmsTransactionalConnection connect() throws ConnectionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Connection Started");
        }
        this.disconnecting.set(false);
        try {
            Connection connection = this.createConnection();
            connection.start();
            if (this.isXa) {
                this.xaJmsTransactionalConnection = new XaJmsTransactionalConnection(this.jmsSupport, connection, this.jmsSessionManager, this.exceptionListener);
                return this.xaJmsTransactionalConnection;
            }
            return new JmsTransactionalConnection(this.jmsSupport, connection, this.jmsSessionManager, this.exceptionListener);
        }
        catch (Exception e) {
            block7: {
                try {
                    LifecycleUtils.stopIfNeeded((Object)this.jmsConnectionFactory);
                }
                catch (MuleException factoryStopException) {
                    if (!LOGGER.isDebugEnabled()) break block7;
                    LOGGER.debug("Failed to reset cached connection: ", (Throwable)factoryStopException);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed create connection: ", (Throwable)e);
            }
            throw new ConnectionException((Throwable)e);
        }
    }

    public ConnectionValidationResult validate(JmsTransactionalConnection jmsConnection) {
        LOGGER.debug("Validating connection");
        try {
            Connection connection = jmsConnection.get();
            connection.start();
            ConnectionValidationResult res = this.validateWithTimeout(jmsConnection);
            if (res.isValid()) {
                return res;
            }
            return ConnectionValidationResult.failure((String)"Connection validation failure", (Exception)res.getException());
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
            if (jmsConnection instanceof XaJmsTransactionalConnection) {
                LOGGER.debug("Closing XA transaction");
                JmsCommons.closeQuietly((AutoCloseable)jmsConnection.get());
                try {
                    LifecycleUtils.disposeIfNeeded((Object)this.jmsConnectionFactory, (Logger)LOGGER);
                    this.initialiseConnectionFactory();
                    this.xaJmsTransactionalConnection.close();
                    LOGGER.debug("Create Connection");
                    Connection connection = this.createConnection();
                    connection.start();
                    this.xaJmsTransactionalConnection.setConnection(connection);
                    ConnectionValidationResult res2 = this.validateWithTimeout(this.xaJmsTransactionalConnection);
                    if (res2.isValid()) {
                        LOGGER.debug("Validation succeeded");
                        return ConnectionValidationResult.success();
                    }
                    LOGGER.debug("Connection Validation Failure");
                    return ConnectionValidationResult.failure((String)"Connection Validation Failure", (Exception)res2.getException());
                }
                catch (Exception e2) {
                    LOGGER.debug("Handled exception on connection validation", (Throwable)e2);
                    return ConnectionValidationResult.failure((String)"Invalid connection provided: Connection could not be started.", (Exception)e2);
                }
            }
            LOGGER.debug("Could not validate connection - No XA Transactiongit  -", (Throwable)e1);
            return ConnectionValidationResult.failure((String)"Could not validate connection", (Exception)e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionValidationResult validateWithTimeout(JmsTransactionalConnection jmsConnection) throws InterruptedException, ExecutionException, TimeoutException {
        LOGGER.debug("validateWithTimeout");
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern(VALIDATION_THREAD_NAME_PATTERN).build();
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
        Future<ConnectionValidationResult> future = null;
        try {
            LOGGER.debug("validateWithTimeout - Submit Validation Task");
            future = executor.submit(new JmsConnectionValidationTask(jmsConnection));
            ConnectionValidationResult res = future.get(10L, TimeUnit.SECONDS);
            LOGGER.debug("validateWithTimeout - Receive Validation Task");
            ConnectionValidationResult connectionValidationResult = res;
            return connectionValidationResult;
        }
        catch (TimeoutException e) {
            LOGGER.debug("JmsConnectionProvider.validateWithTimeout", (Throwable)e);
            future.cancel(true);
            ConnectionValidationResult connectionValidationResult = ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
            return connectionValidationResult;
        }
        finally {
            LOGGER.debug("validateWithTimeout - finally");
            executor.shutdownNow();
        }
    }

    public void disconnect(JmsTransactionalConnection jmsConnection) {
        LOGGER.debug("Disconnection Started");
        this.disconnecting.set(true);
        this.exceptionListener = new CompositeJmsExceptionListener();
        this.doStop(jmsConnection);
        this.doClose(jmsConnection);
    }

    protected void doStop(JmsConnection jmsConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Perform doStop: [%s]", this.getClass().getName()));
        }
        JmsCommons.stopQuietly(jmsConnection);
        LifecycleUtils.disposeIfNeeded((Object)jmsConnection, (Logger)LOGGER);
        JmsCommons.stopQuietly(this.jmsConnectionFactory);
        LifecycleUtils.disposeIfNeeded((Object)this.jmsConnectionFactory, (Logger)LOGGER);
    }

    protected void doClose(JmsConnection jmsConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Perform doClose: [%s]", this.getClass().getName()));
        }
        LifecycleUtils.disposeIfNeeded((Object)jmsConnection, (Logger)LOGGER);
    }

    public void dispose() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Disposing [%s]", this.getClass().getName()));
        }
        LifecycleUtils.disposeIfNeeded((Object)this.jmsConnectionFactory, (Logger)LOGGER);
    }

    private void initialiseConnectionFactory() throws Exception {
        LOGGER.debug("Initialising Connection Factory");
        ConnectionFactory targetFactory = this.getConnectionFactory();
        LifecycleUtils.initialiseIfNeeded((Object)targetFactory);
        if (this.cachingStrategy.appliesTo(targetFactory) && this.cachingStrategy.strategyConfiguration().isPresent()) {
            if (this.isXa) {
                throw new IllegalStateException("An XA ConnectionFactory cannot be used with a caching connection.");
            }
            this.isCacheEnabled = true;
            String username = this.getConnectionParameters().getUsername();
            String password = this.getConnectionParameters().getPassword();
            String clientId = this.getConnectionParameters().getClientId();
            this.jmsConnectionFactory = this.isIBM ? new IBMJmsCachingConnectionFactory(targetFactory, username, password, clientId, this.cachingStrategy.strategyConfiguration().get(), this.jmsSupport, this.exceptionListener, this.reconnectionManager) : new JmsCachingConnectionFactory(targetFactory, username, password, clientId, this.cachingStrategy.strategyConfiguration().get(), this.jmsSupport, this.exceptionListener, this.setupSsl);
            LifecycleUtils.initialiseIfNeeded((Object)this.jmsConnectionFactory);
        } else {
            LOGGER.debug("Skip CachingConnectionFactory Wrapper");
            this.jmsConnectionFactory = targetFactory;
        }
    }

    protected void createJmsSupport() {
        JmsSpecification specification = this.getSpecification();
        this.jmsSupport = JmsSpecification.JMS_1_0_2b.equals((Object)specification) ? this.jmsSupportFactory.create102bSupport() : (JmsSpecification.JMS_2_0.equals((Object)specification) ? this.jmsSupportFactory.create20Support() : this.jmsSupportFactory.create11Support());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("JMS Support set to [%s]", this.jmsSupport.getSpecification().getName()));
        }
    }

    private Connection createConnection() throws JMSException {
        Connection connection;
        block6: {
            String username = this.getConnectionParameters().getUsername();
            String password = this.getConnectionParameters().getPassword();
            connection = this.isCacheEnabled || StringUtils.isBlank((CharSequence)username) ? this.jmsSupport.createConnection(this.jmsConnectionFactory) : this.jmsSupport.createConnection(this.jmsConnectionFactory, username, password);
            if (connection == null) {
                throw new IllegalStateException("An error occurred, Connection cannot be null after creation");
            }
            if (!this.isCacheEnabled) {
                String clientId = this.getConnectionParameters().getClientId();
                if (!StringUtils.isBlank((CharSequence)clientId) && !clientId.equals(connection.getClientID())) {
                    connection.setClientID(clientId);
                }
                if (connection.getExceptionListener() == null) {
                    try {
                        connection.setExceptionListener((ExceptionListener)this.exceptionListener);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isDebugEnabled()) break block6;
                        LOGGER.debug("An error occurred while setting the ExceptionListener. No ExceptionListener is available in a Java EE web or EJB application. ", (Throwable)e);
                    }
                }
            }
        }
        return connection;
    }

    public GenericConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    public JmsSupport getJmsSupport() {
        return this.jmsSupport;
    }

    protected void setJmsSupport(JmsSupport jmsSupport) {
        this.jmsSupport = jmsSupport;
    }

    public JmsSpecification getSpecification() {
        return this.specification;
    }
}

