/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection.session;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsMessageAckedMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageAckedMonitor.class);
    private static final long CONSUMER_RESOURCE_RELEASE_TIMEOUT_MILLISECONDS = 20000L;
    final Lock messageAckedLock = new ReentrantLock();
    final Condition messageAckedCondition = this.messageAckedLock.newCondition();
    boolean messageAcked = false;

    public void notifyMessageAcked() {
        this.messageAckedLock.lock();
        try {
            this.messageAcked = true;
            if (this.messageAckedCondition != null) {
                this.messageAckedCondition.signal();
            }
        }
        finally {
            this.messageAckedLock.unlock();
        }
    }

    public void waitForMessageAcked() {
        this.messageAckedLock.lock();
        try {
            while (!this.messageAcked) {
                this.messageAckedCondition.await(20000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage());
        }
        finally {
            this.messageAckedLock.unlock();
        }
    }
}

