/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.source.polling;

import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.consume.JmsMessageConsumer;

import javax.jms.Destination;
import javax.jms.JMSException;

/**
 * {@link JmsMessageConsumer} factory pattern implementation.
 *
 * @since 1.4.0
 */
public class MessageConsumerFactory {

  private JmsConnection connection;
  private final String destination;
  private final JmsConfig jmsConfig;
  private final String selector;
  private final ConsumerType consumerType;

  MessageConsumerFactory(JmsConnection connection, String destination, String selector, ConsumerType consumerType,
                         JmsConfig jmsConfig) {
    this.connection = connection;
    this.destination = destination;
    this.jmsConfig = jmsConfig;
    this.selector = selector;
    this.consumerType = consumerType;
  }

  public JmsMessageConsumer createConsumer(JmsSession session) throws JMSException {
    final Destination jmsDestination =
        connection.getJmsSupport().createDestination(session.get(), destination, consumerType.topic(), jmsConfig);
    return connection.createConsumer(session, jmsDestination, selector, consumerType);
  }
}
