/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.apache.commons.lang3.StringUtils;
import org.mule.jms.commons.api.connection.JmsReconnectionManager;
import org.mule.jms.commons.api.connection.caching.CachingConfiguration;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.connection.SessionProxy;
import org.springframework.util.ClassUtils;

public class IBMJmsCachingConnectionFactory
extends CachingConnectionFactory
implements Stoppable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IBMJmsCachingConnectionFactory.class);
    private final String username;
    private final String password;
    private final JmsSupport jmsSupport;
    private final String clientId;
    private final ExceptionListener exceptionListener;
    private JmsReconnectionManager reconnectionManager;

    public IBMJmsCachingConnectionFactory(ConnectionFactory targetConnectionFactory, String username, String password, String clientId, CachingConfiguration config, JmsSupport jmsSupport, ExceptionListener exceptionListener, JmsReconnectionManager priorityManager) {
        super(targetConnectionFactory);
        Preconditions.checkArgument((!(targetConnectionFactory instanceof CachingConnectionFactory) ? 1 : 0) != 0, (String)"The ConnectionFactory provided shouldn't be wrapped in a IBMJmsCachingConnectionFactory");
        super.setCacheConsumers(config.isConsumersCache());
        super.setCacheProducers(config.isProducersCache());
        super.setSessionCacheSize(config.getSessionCacheSize());
        super.setReconnectOnException(true);
        this.exceptionListener = exceptionListener;
        this.username = username;
        this.password = password;
        this.clientId = clientId;
        this.jmsSupport = jmsSupport;
        this.reconnectionManager = priorityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException e) {
        IBMJmsCachingConnectionFactory iBMJmsCachingConnectionFactory;
        try {
            iBMJmsCachingConnectionFactory = this;
            synchronized (iBMJmsCachingConnectionFactory) {
                this.reconnectionManager.reconnecting();
            }
            LOGGER.info("Handling exception in Mule's CompositeExceptionListener: {}", (Throwable)e);
            this.exceptionListener.onException(e);
            LOGGER.info("Handling exception in Spring's SingleConnectionFactory: {}", (Throwable)e);
            super.onException(e);
        }
        finally {
            iBMJmsCachingConnectionFactory = this;
            synchronized (iBMJmsCachingConnectionFactory) {
                this.reconnectionManager.finishReconnecting();
            }
        }
    }

    public void destroy() {
        if (!this.reconnectionManager.isReconnecting()) {
            super.destroy();
        }
    }

    protected Connection getConnection() throws JMSException {
        if (this.reconnectionManager.isReconnecting()) {
            throw new JMSException("Creating a connection while reconnecting");
        }
        return super.getConnection();
    }

    protected Session getSession(Connection con, Integer mode) throws JMSException {
        if (this.reconnectionManager.isReconnecting()) {
            throw new JMSException("Creating a session while reconnecting");
        }
        Session target = super.getSession(con, mode);
        ArrayList<Class<TopicSession>> classes = new ArrayList<Class<TopicSession>>(3);
        classes.add(SessionProxy.class);
        if (target instanceof QueueSession) {
            classes.add(QueueSession.class);
        }
        if (target instanceof TopicSession) {
            classes.add(TopicSession.class);
        }
        return (Session)Proxy.newProxyInstance(SessionProxy.class.getClassLoader(), ClassUtils.toClassArray(classes), (InvocationHandler)new IBMSessionProxyHandler(target, this.reconnectionManager, this.isCacheProducers()));
    }

    protected synchronized Connection doCreateConnection() throws JMSException {
        if (this.reconnectionManager.isReconnecting()) {
            throw new JMSException("Creating a connection while reconnecting");
        }
        Connection connection = StringUtils.isBlank((CharSequence)this.username) ? this.jmsSupport.createConnection(this.getTargetConnectionFactory()) : this.jmsSupport.createConnection(this.getTargetConnectionFactory(), this.username, this.password);
        if (!StringUtils.isBlank((CharSequence)this.clientId)) {
            connection.setClientID(this.clientId);
        }
        return connection;
    }

    public void stop() {
        this.resetConnection();
    }

    public void dispose() {
        this.destroy();
    }

    public Connection createConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("JmsCachingConnectionFactory does not support creating a connection with username and password. Provide the desired username and password when the instance is defined");
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("JmsCachingConnectionFactory does not support creating a connection with username and password. Provide the desired username and password when the instance is defined");
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("JmsCachingConnectionFactory does not support creating a connection with username and password. Provide the desired username and password when the instance is defined");
    }

    public JMSContext createContext() {
        return null;
    }

    public JMSContext createContext(String userName, String password) {
        return null;
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        return null;
    }

    public JMSContext createContext(int sessionMode) {
        return null;
    }

    private static class IBMProducerProxyHandler
    implements InvocationHandler {
        private Object target;
        private IBMSessionProxyHandler ibmSessionProxyHandler;

        public IBMProducerProxyHandler(Object target, IBMSessionProxyHandler ibmSessionProxyHandler) {
            this.target = target;
            this.ibmSessionProxyHandler = ibmSessionProxyHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                String methodName = method.getName();
                if (methodName.equals("send")) {
                    IBMSessionProxyHandler iBMSessionProxyHandler = this.ibmSessionProxyHandler;
                    synchronized (iBMSessionProxyHandler) {
                        return method.invoke(this.target, args);
                    }
                }
                return method.invoke(this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static class IBMSessionProxyHandler
    implements InvocationHandler {
        Session target;
        private JmsReconnectionManager reconnectionManager;
        private boolean cachedProducers;

        public IBMSessionProxyHandler(Session target, JmsReconnectionManager reconnectionManager, boolean cachedProducers) {
            this.target = target;
            this.reconnectionManager = reconnectionManager;
            this.cachedProducers = cachedProducers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Destination dest;
                if (this.reconnectionManager.isReconnecting()) {
                    throw new JMSException("The connection is being reset");
                }
                String methodName = method.getName();
                if (methodName.equals("close")) {
                    IBMSessionProxyHandler iBMSessionProxyHandler = this;
                    synchronized (iBMSessionProxyHandler) {
                        return method.invoke((Object)this.target, args);
                    }
                }
                if (this.cachedProducers && (methodName.equals("createProducer") || methodName.equals("createSender") || methodName.equals("createPublisher")) && !((dest = (Destination)args[0]) instanceof TemporaryQueue) && !(dest instanceof TemporaryTopic)) {
                    ArrayList<Class<MessageProducer>> classes = new ArrayList<Class<MessageProducer>>(1);
                    classes.add(MessageProducer.class);
                    return Proxy.newProxyInstance(MessageProducer.class.getClassLoader(), ClassUtils.toClassArray(classes), (InvocationHandler)new IBMProducerProxyHandler(method.invoke((Object)this.target, args), this));
                }
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

