/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.api.message;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mule.jms.commons.api.message.JmsxProperties;
import org.mule.jms.commons.internal.message.JMSXDefinedPropertiesNames;
import org.mule.jms.commons.internal.message.JmsxPropertiesBuilder;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public class JmsMessageProperties
implements Serializable {
    private static final String JMSX_PREFIX = "JMSX";
    private static final String JMS_PREFIX = "JMS";
    @Parameter
    private final Map<String, Object> all;
    @Parameter
    private final Map<String, Object> userProperties = new HashMap<String, Object>();
    @Parameter
    private final Map<String, Object> jmsProperties = new HashMap<String, Object>();
    @Parameter
    private JmsxProperties jmsxProperties;

    public JmsMessageProperties(Map<String, Object> messageProperties) {
        Preconditions.checkArgument((messageProperties != null ? 1 : 0) != 0, (String)"Initializer properties Map expected, but it was null");
        this.all = ImmutableMap.copyOf(messageProperties);
        JmsxPropertiesBuilder jmsxPropertiesBuilder = JmsxPropertiesBuilder.create();
        this.all.entrySet().forEach(e -> {
            String key = (String)e.getKey();
            if (key.startsWith(JMSX_PREFIX) && JMSXDefinedPropertiesNames.JMSX_NAMES.contains(key)) {
                jmsxPropertiesBuilder.add(key, e.getValue());
            } else if (key.startsWith(JMS_PREFIX)) {
                this.jmsProperties.put(key, e.getValue());
            } else {
                this.userProperties.put(key, e.getValue());
            }
        });
        this.jmsxProperties = jmsxPropertiesBuilder.build();
    }

    public Map<String, Object> asMap() {
        return ImmutableMap.copyOf(this.all);
    }

    public Map<String, Object> getUserProperties() {
        return ImmutableMap.copyOf(this.userProperties);
    }

    public Map<String, Object> getJmsProperties() {
        return ImmutableMap.copyOf(this.jmsProperties);
    }

    public JmsxProperties getJmsxProperties() {
        return this.jmsxProperties;
    }

    public boolean equals(Object o) {
        return this.all.equals(o);
    }

    public int hashCode() {
        return this.all.hashCode();
    }
}

