/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJmsListenerLock
implements JmsListenerLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJmsListenerLock.class);
    private final AtomicBoolean isUnlocked = new AtomicBoolean(false);
    private final AtomicBoolean isFailure = new AtomicBoolean(false);
    private final Semaphore semaphore = new Semaphore(0);
    private Throwable cause;
    private Runnable action;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        try {
            while (!this.isUnlocked.get()) {
                this.semaphore.acquire();
                if (this.action == null) continue;
                LOGGER.debug("About to execute action on Listener Thread");
                this.action.run();
                this.action = null;
            }
            LOGGER.trace("JMS Listener lock has been unlocked.");
        }
        catch (InterruptedException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The JMS Listener Lock has been interrupted."), this.cause);
        }
        AtomicBoolean atomicBoolean = this.isUnlocked;
        synchronized (atomicBoolean) {
            if (this.isFailure.get()) {
                throw new MuleRuntimeException(this.cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockWithFailure(Error error) {
        AtomicBoolean atomicBoolean = this.isUnlocked;
        synchronized (atomicBoolean) {
            this.isFailure.compareAndSet(false, true);
            this.isUnlocked.compareAndSet(false, true);
            this.cause = error.getCause();
        }
        this.releaseIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockWithFailure() {
        AtomicBoolean atomicBoolean = this.isUnlocked;
        synchronized (atomicBoolean) {
            this.isFailure.compareAndSet(false, true);
            this.isUnlocked.compareAndSet(false, true);
            this.cause = new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The JMS Lock has been unlocked indicating that a session recover should be executed."));
        }
        this.releaseIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        AtomicBoolean atomicBoolean = this.isUnlocked;
        synchronized (atomicBoolean) {
            this.isFailure.compareAndSet(true, false);
            this.isUnlocked.compareAndSet(false, true);
        }
        this.releaseIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeOnListenerThread(Runnable runnable) {
        LOGGER.trace("About to execute runnable on listener thread.");
        AtomicBoolean atomicBoolean = this.isUnlocked;
        synchronized (atomicBoolean) {
            if (this.isUnlocked.get()) {
                LOGGER.trace("Listener thread is not more available, running on current thread.");
                runnable.run();
            } else {
                this.action = runnable;
                this.releaseIfNecessary();
            }
        }
    }

    @Override
    public void init() {
        this.isUnlocked.set(false);
        this.isFailure.set(false);
        this.cause = null;
        this.action = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseIfNecessary() {
        Semaphore semaphore = this.semaphore;
        synchronized (semaphore) {
            if (this.isSemaphoreWithOutAvailablePermits()) {
                this.semaphore.release();
            }
        }
    }

    private boolean isSemaphoreWithOutAvailablePermits() {
        return this.semaphore.availablePermits() == 0;
    }
}

