/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.connection;

import javax.transaction.xa.XAResource;

/**
 * Wrapper for an {@link XAResource} which makes it compatible with XA Transactions
 * in Mule 4.
 *
 * @since 1.4.0
 */
public class JmsXaContext {

  private XAResource xaResource;
  private Runnable runnable;

  public JmsXaContext(XAResource xaResource) {
    this.xaResource = xaResource;
  }

  public XAResource getXaResource() {
    return xaResource;
  }

  public void end() {
    if (runnable != null) {
      runnable.run();
    }
  }

  public void afterEnds(Runnable runnable) {
    this.runnable = runnable;
  }
}
