/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.config;

import org.mule.jms.commons.api.config.JmsConsumerConfig;
import org.mule.jms.commons.api.config.JmsProducerConfig;

import javax.jms.Destination;
import javax.jms.JMSException;

public interface JmsConfig<Consumer extends JmsConsumerConfig, Produce extends JmsProducerConfig> {

  String getContentType();

  String getEncoding();

  Consumer getConsumerConfig();

  Produce getProducerConfig();
}
