/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.source;

import org.mule.jms.commons.api.destination.DefaultJmsDestination;
import org.mule.jms.commons.api.destination.JmsDestination;
import org.mule.jms.commons.api.message.DefaultJmsMessageBuilder;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;

import java.util.concurrent.TimeUnit;

import javax.jms.Message;

/**
 * Enables the creation of an outgoing {@link Message} along with the response configuration.
 * Users must use this builder to create a message response instance.
 *
 * @since 1.0
 */
public class DefaultJmsResponseMessageBuilder extends DefaultJmsMessageBuilder<DefaultJmsDestination>
    implements JmsResponseMessageBuilder<DefaultJmsDestination> {

  /**
   * Whether or not the delivery should be done with a persistent configuration
   */
  @Parameter
  @ConfigOverride
  @Summary("Whether or not the delivery should be done with a persistent configuration")
  private boolean persistentDelivery;

  /**
   * The default JMSPriority value to be used when sending the message
   */
  @Parameter
  @ConfigOverride
  @Summary("The default JMSPriority value to be used when sending the message")
  private Integer priority;

  /**
   * Defines the default time the message will be in the broker before it expires and is discarded
   */
  @Parameter
  @ConfigOverride
  @Summary("Defines the default time the message will be in the broker before it expires and is discarded")
  private Long timeToLive;

  /**
   * Time unit to be used in the timeToLive configurations
   */
  @Parameter
  @ConfigOverride
  @Summary("Time unit to be used in the timeToLive configurations")
  private TimeUnit timeToLiveUnit;

  /**
   * If true; the Message will be flagged to avoid generating its MessageID
   */
  @Parameter
  @ConfigOverride
  @Summary("If true; the Message will be flagged to avoid generating its MessageID")
  private boolean disableMessageId;

  /**
   * If true; the Message will be flagged to avoid generating its sent Timestamp
   */
  @Parameter
  @ConfigOverride
  @Summary("If true; the Message will be flagged to avoid generating its sent Timestamp")
  private boolean disableMessageTimestamp;

  // JMS 2.0
  /**
   * Only used by JMS 2.0. Sets the delivery delay to be applied in order to postpone the Message delivery
   */
  @Parameter
  @ConfigOverride
  @Summary("Only used by JMS 2.0. Sets the delivery delay to be applied in order to postpone the Message delivery")
  private Long deliveryDelay;

  /**
   * Time unit to be used in the deliveryDelay configurations
   */
  @Parameter
  @ConfigOverride
  @Summary("Time unit to be used in the deliveryDelay configurations")
  private TimeUnit deliveryDelayUnit;

  /**
   * Options on whether to include an outbound correlation id or not
   *
   * @since 1.1.0
   */
  @Parameter
  @ConfigOverride
  private OutboundCorrelationStrategy sendCorrelationId;

  @Override
  public boolean isPersistentDelivery() {
    return persistentDelivery;
  }

  @Override
  public Integer getPriority() {
    return priority;
  }

  @Override
  public Long getTimeToLive() {
    return timeToLive;
  }

  @Override
  public TimeUnit getTimeToLiveUnit() {
    return timeToLiveUnit;
  }

  @Override
  public boolean isDisableMessageId() {
    return disableMessageId;
  }

  @Override
  public boolean isDisableMessageTimestamp() {
    return disableMessageTimestamp;
  }

  @Override
  public Long getDeliveryDelay() {
    return deliveryDelay;
  }

  @Override
  public TimeUnit getDeliveryDelayUnit() {
    return deliveryDelayUnit;
  }

  @Override
  public OutboundCorrelationStrategy getSendCorrelationId() {
    return sendCorrelationId;
  }
}
