/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.support;

public interface JmsSupportFactory {

  JmsSupportFactory DEFAULT = new JmsSupportFactory() {};

  default JmsSupport create11Support() {
    return new Jms11Support();
  }

  default JmsSupport create102bSupport() {
    return new Jms102bSupport();
  }

  default JmsSupport create20Support() {
    return new Jms20Support();
  }

}
