/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source.polling;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.api.exception.JmsExtensionException;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.source.JmsConnectionExceptionResolver;
import org.mule.jms.commons.internal.source.MessageConsumerDelegate;
import org.mule.jms.commons.internal.source.polling.JmsXaMessageConsumer;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsXaPollingMessageConsumerDelegate
implements MessageConsumerDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsXaPollingMessageConsumerDelegate.class);
    private final String destination;
    private final ConsumerType consumerType;
    private final JmsConfig config;
    private final String selector;
    private final JmsSessionManager sessionManager;
    private final ConnectionProvider connectionProvider;
    private final Scheduler scheduler;
    private final String inboundContentType;
    private final String inboundEncoding;
    private final JmsConnectionExceptionResolver exceptionResolver;
    private JmsTransactionalConnection connection;
    private JmsSupport jmsSupport;
    private SourceCallback sourceCallback;
    static final String CONSUMER_CONTEXT_VAR = "CONSUMER";
    private final List<JmsXaMessageConsumer> xaMessageConsumers = new ArrayList<JmsXaMessageConsumer>();

    public JmsXaPollingMessageConsumerDelegate(JmsTransactionalConnection connection, JmsSupport jmsSupport, String destination, ConsumerType consumerType, JmsConfig config, String selector, JmsSessionManager sessionManager, ConnectionProvider connectionProvider, Scheduler scheduler, String inboundContentType, String inboundEncoding, SourceCallback sourceCallback, JmsConnectionExceptionResolver exceptionResolver) {
        this.connection = connection;
        this.jmsSupport = jmsSupport;
        this.destination = destination;
        this.consumerType = consumerType;
        this.config = config;
        this.selector = selector;
        this.sessionManager = sessionManager;
        this.connectionProvider = connectionProvider;
        this.scheduler = scheduler;
        this.inboundContentType = inboundContentType;
        this.inboundEncoding = inboundEncoding;
        this.sourceCallback = sourceCallback;
        this.exceptionResolver = exceptionResolver;
    }

    @Override
    public void createConsumers(int numberOfConsumers) throws ConnectionException {
        try {
            for (int i = 0; i < numberOfConsumers; ++i) {
                Latch xaTransactionInitialization = new Latch();
                JmsXaMessageConsumer messageConsumer = new JmsXaMessageConsumer(s -> {
                    try {
                        Destination jmsDestination = this.jmsSupport.createDestination(s.get(), this.destination, this.consumerType.topic(), this.config);
                        return this.connection.createConsumer((JmsSession)s, jmsDestination, this.selector, this.consumerType);
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                        return null;
                    }
                }, this.sourceCallback, this.sessionManager, this.connectionProvider, this.config, this.inboundContentType, this.inboundEncoding, this.jmsSupport.getSpecification(), i, (CountDownLatch)xaTransactionInitialization, this.exceptionResolver);
                this.xaMessageConsumers.add(messageConsumer);
                this.scheduler.submit((Runnable)messageConsumer);
                xaTransactionInitialization.await();
            }
        }
        catch (JmsExtensionException e) {
            String msg = String.format("An error occurred while creating the consumers for destination [%s:%s]: %s", JmsCommons.getDestinationType(this.consumerType), this.destination, e.getMessage());
            LOGGER.error(msg, (Throwable)((Object)e));
            this.stop();
            throw new ConnectionException(msg, (Throwable)((Object)e), null, (Object)this.connection);
        }
        catch (InterruptedException e) {
            throw new JmsExtensionException("The JMS Consumer creation has been interrupted, probably the Listener is being stopped. ", e);
        }
    }

    @Override
    public void onSuccess(SourceCallbackContext callbackContext) {
        callbackContext.getVariable(CONSUMER_CONTEXT_VAR).ifPresent(runnable -> this.sessionManager.getJmsXaContext(this.connection).ifPresent(xaResource -> xaResource.afterEnds(() -> this.scheduler.submit(runnable))));
    }

    @Override
    public void onError(SourceCallbackContext callbackContext, Error error) {
        callbackContext.getVariable(CONSUMER_CONTEXT_VAR).ifPresent(arg_0 -> this.scheduler.submit(arg_0));
    }

    @Override
    public void stop() {
        this.xaMessageConsumers.forEach(JmsXaMessageConsumer::stop);
    }

    @Override
    public void disableConsumers() {
        this.xaMessageConsumers.forEach(c -> c.stop());
    }
}

