/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.connection.provider;

import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.core.api.MuleContext;

/**
 * Factory for a decorator of the {@link javax.jms.ConnectionFactory}.
 *
 * @since 1.4.0
 */
public class ConnectionFactoryDecoratorFactory {

  public InternalConnectionFactoryDecorator create(MuleContext muleContext, Registry registry) {
    return new InternalConnectionFactoryDecorator(muleContext, registry);
  }
}
