/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.transaction.xa.XAResource;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.JmsXaContext;
import org.mule.jms.commons.internal.connection.exception.CompositeJmsExceptionListener;
import org.mule.jms.commons.internal.connection.session.DefaultJmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.tx.MuleXaObject;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XaJmsTransactionalConnection
extends JmsTransactionalConnection
implements XATransactionalConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(XaJmsTransactionalConnection.class);
    private final JmsSupport jmsSupport;
    private Connection connection;
    private final JmsSessionManager jmsSessionManager;
    private final CompositeJmsExceptionListener exceptionListener;
    private static final Method getXAResourceMethod;

    public XaJmsTransactionalConnection(JmsSupport jmsSupport, Connection connection, JmsSessionManager jmsSessionManager, CompositeJmsExceptionListener exceptionListener) {
        super(jmsSupport, connection, jmsSessionManager, exceptionListener);
        this.jmsSupport = jmsSupport;
        this.connection = connection;
        this.jmsSessionManager = jmsSessionManager;
        this.exceptionListener = exceptionListener;
    }

    public XAResource getXAResource() {
        Optional<JmsXaContext> optionalJmsXaContext = this.jmsSessionManager.getJmsXaContext(this);
        if (optionalJmsXaContext.isPresent()) {
            return optionalJmsXaContext.get().getXaResource();
        }
        try {
            Session session = this.jmsSupport.createSession(this.connection, false, true, InternalAckMode.TRANSACTED.getAckModeValue());
            session.createMessage();
            XAResource xaResource = this.getXAResource((MuleXaObject)session);
            this.jmsSessionManager.bindToTransaction(this, new DefaultJmsSession(session), new JmsXaContext(xaResource));
            return xaResource;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private XAResource getXAResource(MuleXaObject session) throws IllegalAccessException, InvocationTargetException {
        return (XAResource)getXAResourceMethod.invoke(session.getTargetObject(), new Object[0]);
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
        super.setConnection(connection);
    }

    public JmsSession getSession(InternalAckMode ackMode, boolean isTopic) throws JMSException {
        Optional<JmsSession> transactedSession = this.jmsSessionManager.getXaTransactedSession(this);
        if (transactedSession.isPresent()) {
            return transactedSession.get();
        }
        return this.createSession(ackMode, isTopic);
    }

    public void close() {
        this.jmsSessionManager.getTransactedSession(this).ifPresent(ts -> JmsCommons.closeQuietly(ts));
        this.jmsSessionManager.getJmsXaContext(this).ifPresent(jmx -> {
            try {
                jmx.end();
            }
            catch (Throwable t) {
                LOGGER.warn("Exception found while stopping Jms XA Context", t);
            }
        });
        this.jmsSessionManager.unbindSession();
    }

    static {
        try {
            Class<?> aClass = ExtensionManager.class.getClassLoader().loadClass("bitronix.tm.resource.jms.DualSessionWrapper");
            getXAResourceMethod = aClass.getMethod("getXAResource", new Class[0]);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

