/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection.provider;

import com.mulesoft.mule.runtime.bti.api.jms.ConnectionFactoryDecorator;
import com.mulesoft.mule.runtime.bti.api.jms.JmsConnectionConfig;
import java.util.Collection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.core.api.MuleContext;

public class InternalConnectionFactoryDecorator {
    private MuleContext muleContext;
    private Registry registry;

    public InternalConnectionFactoryDecorator(MuleContext muleContext, Registry registry) {
        this.muleContext = muleContext;
        this.registry = registry;
    }

    public ConnectionFactory decorate(ConnectionFactory connectionFactory, String configName, boolean reuseSessions, String username, String password, String clientId, ExceptionListener exceptionListener) {
        Collection decorators = this.registry.lookupAllByType(ConnectionFactoryDecorator.class);
        ConnectionFactory decoratedConnectionFactory = connectionFactory;
        if (!decorators.isEmpty()) {
            JmsConnectionConfig build = new JmsConnectionConfig.Builder(configName).setReuseSessions(reuseSessions).setUserName(username).setPassword(password).setClientId(clientId).setExceptionListener(exceptionListener).build();
            for (ConnectionFactoryDecorator decorator : decorators) {
                if (!decorator.appliesTo(decoratedConnectionFactory, this.muleContext)) continue;
                decoratedConnectionFactory = decorator.decorate(decoratedConnectionFactory, build, this.muleContext);
            }
        }
        return decoratedConnectionFactory;
    }
}

