/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection.provider;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.apache.commons.lang3.StringUtils;
import org.mule.jms.commons.api.connection.JmsSpecification;
import org.mule.jms.commons.api.connection.caching.CachingStrategy;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.connection.JmsCachingConnectionFactory;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.XaJmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.exception.CompositeJmsExceptionListener;
import org.mule.jms.commons.internal.connection.param.GenericConnectionParameters;
import org.mule.jms.commons.internal.connection.provider.ConnectionFactoryDecoratorFactory;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.jms.commons.internal.support.JmsSupportFactory;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConnectionProvider
implements CachedConnectionProvider<JmsTransactionalConnection>,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConnectionProvider.class);
    private final JmsSessionManager jmsSessionManager;
    private XaJmsTransactionalConnection xaJmsTransactionalConnection;
    private Supplier<ConnectionFactory> connectionFactorySupplier;
    private final JmsSpecification specification;
    private final GenericConnectionParameters connectionParameters;
    private final CachingStrategy cachingStrategy;
    private boolean isXa;
    private JmsSupportFactory jmsSupportFactory;
    private final MuleContext muleContext;
    private final Registry registry;
    private String configName;
    private CompositeJmsExceptionListener exceptionListener = new CompositeJmsExceptionListener();
    private AtomicBoolean disconnecting = new AtomicBoolean(false);
    private JmsSupport jmsSupport;
    private ConnectionFactory jmsConnectionFactory;
    private boolean isCacheEnabled = false;

    public JmsConnectionProvider(JmsSessionManager jmsSessionManager, Supplier<ConnectionFactory> connectionFactorySupplier, JmsSpecification specification, GenericConnectionParameters connectionParameters, CachingStrategy cachingStrategy, boolean isXa, JmsSupportFactory jmsSupportFactory, MuleContext muleContext, Registry registry, String configName) throws InitialisationException {
        this.jmsSessionManager = jmsSessionManager;
        this.connectionFactorySupplier = connectionFactorySupplier;
        this.specification = specification;
        this.connectionParameters = connectionParameters;
        this.cachingStrategy = cachingStrategy;
        this.isXa = isXa;
        this.jmsSupportFactory = jmsSupportFactory;
        this.muleContext = muleContext;
        this.registry = registry;
        this.configName = configName;
        this.initialise();
    }

    public ConnectionFactory getConnectionFactory() throws Exception {
        ConnectionFactory connectionFactory = this.connectionFactorySupplier.get();
        return new ConnectionFactoryDecoratorFactory().create(this.muleContext, this.registry).decorate(connectionFactory, this.configName, true, this.connectionParameters.getUsername(), this.connectionParameters.getPassword(), this.connectionParameters.getClientId(), this.exceptionListener);
    }

    public void initialise() throws InitialisationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Executing initialise for [%s]", this.getClass().getName()));
        }
        try {
            this.createJmsSupport();
            this.initialiseConnectionFactory();
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Failed to initialise [%s]: ", this.getClass().getName()), (Throwable)e);
            }
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public JmsTransactionalConnection connect() throws ConnectionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Connection Started");
        }
        this.disconnecting.set(false);
        try {
            Connection connection = this.createConnection();
            connection.start();
            if (this.isXa) {
                this.xaJmsTransactionalConnection = new XaJmsTransactionalConnection(this.jmsSupport, connection, this.jmsSessionManager, this.exceptionListener);
                return this.xaJmsTransactionalConnection;
            }
            return new JmsTransactionalConnection(this.jmsSupport, connection, this.jmsSessionManager, this.exceptionListener);
        }
        catch (Exception e) {
            block7: {
                try {
                    LifecycleUtils.stopIfNeeded((Object)this.jmsConnectionFactory);
                }
                catch (MuleException factoryStopException) {
                    if (!LOGGER.isDebugEnabled()) break block7;
                    LOGGER.debug("Failed to reset cached connection: ", (Throwable)factoryStopException);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed create connection: ", (Throwable)e);
            }
            throw new ConnectionException((Throwable)e);
        }
    }

    public ConnectionValidationResult validate(JmsTransactionalConnection jmsConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Validating connection");
        }
        try {
            jmsConnection.get().start();
            this.validateConnection(jmsConnection);
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            if (jmsConnection instanceof XaJmsTransactionalConnection) {
                JmsCommons.closeQuietly((AutoCloseable)jmsConnection.get());
            }
            try {
                if (this.jmsConnectionFactory instanceof Disposable) {
                    ((Disposable)this.jmsConnectionFactory).dispose();
                }
                this.initialiseConnectionFactory();
                this.xaJmsTransactionalConnection.close();
                Connection connection = this.createConnection();
                connection.start();
                this.xaJmsTransactionalConnection.setConnection(connection);
                this.validateConnection(this.xaJmsTransactionalConnection);
                return ConnectionValidationResult.success();
            }
            catch (Exception exception) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Validation failed: ", (Throwable)e);
                }
                return ConnectionValidationResult.failure((String)"Invalid connection provided: Connection could not be started.", (Exception)e);
            }
        }
    }

    private void validateConnection(JmsTransactionalConnection jmsConnection) throws JMSException {
        JmsSession session = jmsConnection.createSession(InternalAckMode.AUTO, false);
        try {
            session.get().createMessage();
        }
        finally {
            JmsCommons.closeQuietly(session);
        }
    }

    public void disconnect(JmsTransactionalConnection jmsConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Disconnection Started");
        }
        this.disconnecting.set(true);
        this.exceptionListener = new CompositeJmsExceptionListener();
        this.doStop(jmsConnection);
        this.doClose(jmsConnection);
    }

    protected void doStop(JmsConnection jmsConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Perform doStop: [%s]", this.getClass().getName()));
        }
        JmsCommons.stopQuietly(jmsConnection);
        LifecycleUtils.disposeIfNeeded((Object)jmsConnection, (Logger)LOGGER);
        JmsCommons.stopQuietly(this.jmsConnectionFactory);
        LifecycleUtils.disposeIfNeeded((Object)this.jmsConnectionFactory, (Logger)LOGGER);
    }

    protected void doClose(JmsConnection jmsConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Perform doClose: [%s]", this.getClass().getName()));
        }
        LifecycleUtils.disposeIfNeeded((Object)jmsConnection, (Logger)LOGGER);
    }

    public void dispose() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Disposing [%s]", this.getClass().getName()));
        }
        LifecycleUtils.disposeIfNeeded((Object)this.jmsConnectionFactory, (Logger)LOGGER);
    }

    private void initialiseConnectionFactory() throws Exception {
        LOGGER.debug("Initialising Connection Factory");
        ConnectionFactory targetFactory = this.getConnectionFactory();
        LifecycleUtils.initialiseIfNeeded((Object)targetFactory);
        if (this.cachingStrategy.appliesTo(targetFactory) && this.cachingStrategy.strategyConfiguration().isPresent()) {
            if (this.isXa) {
                throw new IllegalStateException("An XA ConnectionFactory cannot be used with a caching connection.");
            }
            this.isCacheEnabled = true;
            String username = this.getConnectionParameters().getUsername();
            String password = this.getConnectionParameters().getPassword();
            String clientId = this.getConnectionParameters().getClientId();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Using CachingConnectionFactory wrapper with: username:[%s], password:[%s], clientId:[%s]", username, password, clientId));
            }
            this.jmsConnectionFactory = new JmsCachingConnectionFactory(targetFactory, username, password, clientId, this.cachingStrategy.strategyConfiguration().get(), this.jmsSupport, this.exceptionListener);
            LifecycleUtils.initialiseIfNeeded((Object)this.jmsConnectionFactory);
        } else {
            LOGGER.debug("Skip CachingConnectionFactory Wrapper");
            this.jmsConnectionFactory = targetFactory;
        }
    }

    protected void createJmsSupport() {
        JmsSpecification specification = this.getSpecification();
        this.jmsSupport = JmsSpecification.JMS_1_0_2b.equals((Object)specification) ? this.jmsSupportFactory.create102bSupport() : (JmsSpecification.JMS_2_0.equals((Object)specification) ? this.jmsSupportFactory.create20Support() : this.jmsSupportFactory.create11Support());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("JMS Support set to [%s]", this.jmsSupport.getSpecification().getName()));
        }
    }

    private Connection createConnection() throws JMSException {
        Connection connection;
        block6: {
            String username = this.getConnectionParameters().getUsername();
            String password = this.getConnectionParameters().getPassword();
            connection = this.isCacheEnabled || StringUtils.isBlank((CharSequence)username) ? this.jmsSupport.createConnection(this.jmsConnectionFactory) : this.jmsSupport.createConnection(this.jmsConnectionFactory, username, password);
            if (connection == null) {
                throw new IllegalStateException("An error occurred, Connection cannot be null after creation");
            }
            if (!this.isCacheEnabled) {
                String clientId = this.getConnectionParameters().getClientId();
                if (!StringUtils.isBlank((CharSequence)clientId) && !clientId.equals(connection.getClientID())) {
                    connection.setClientID(clientId);
                }
                if (connection.getExceptionListener() == null) {
                    try {
                        connection.setExceptionListener((ExceptionListener)this.exceptionListener);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isDebugEnabled()) break block6;
                        LOGGER.debug("An error occurred while setting the ExceptionListener. No ExceptionListener is available in a Java EE web or EJB application. ", (Throwable)e);
                    }
                }
            }
        }
        return connection;
    }

    public GenericConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    public JmsSupport getJmsSupport() {
        return this.jmsSupport;
    }

    protected void setJmsSupport(JmsSupport jmsSupport) {
        this.jmsSupport = jmsSupport;
    }

    public JmsSpecification getSpecification() {
        return this.specification;
    }
}

