/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source.polling;

import java.lang.reflect.Field;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import javax.jms.JMSException;
import javax.jms.Message;
import org.mule.jms.commons.api.connection.JmsSpecification;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.XaJmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.consume.JmsMessageConsumer;
import org.mule.jms.commons.internal.source.JmsConnectionExceptionResolver;
import org.mule.jms.commons.internal.source.JmsMessageDispatcher;
import org.mule.jms.commons.internal.source.NullJmsListenerLock;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsXaMessageConsumer
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsXaMessageConsumer.class);
    private final int id;
    private CountDownLatch initializationCountDownLatch;
    private final Function<JmsSession, JmsMessageConsumer> consumer;
    private final SourceCallback sourceCallback;
    private JmsSession session;
    private final JmsSessionManager sessionManager;
    private final ConnectionProvider connectionProvider;
    private final JmsMessageDispatcher dispatcher;
    private boolean stopRequested = false;

    JmsXaMessageConsumer(Function<JmsSession, JmsMessageConsumer> consumer, SourceCallback sourceCallback, JmsSessionManager sessionManager, ConnectionProvider connectionProvider, JmsConfig config, String inboundContentType, String inboundEncoding, JmsSpecification specification, int id, CountDownLatch initializationCountDownLatch, JmsConnectionExceptionResolver exceptionResolver) {
        this.consumer = consumer;
        this.sourceCallback = sourceCallback;
        this.sessionManager = sessionManager;
        this.connectionProvider = connectionProvider;
        this.id = id;
        this.initializationCountDownLatch = initializationCountDownLatch;
        this.dispatcher = new JmsMessageDispatcher(config, inboundContentType, inboundEncoding, specification, () -> this.session, InternalAckMode.TRANSACTED, sessionManager, sourceCallback, new NullJmsListenerLock(), exceptionResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        try {
            boolean shouldKeepIterating = true;
            LOGGER.debug("[{}] : Starting to poll", (Object)this.id);
            while (shouldKeepIterating && !this.stopRequested) {
                try {
                    LOGGER.trace("[{}] : initializing poll ", (Object)this.id);
                    Pair<SourceCallbackContext, JmsSession> jmsContext = this.initializePoll();
                    this.session = (JmsSession)jmsContext.getSecond();
                    Message message = this.consumer.apply(this.session).get().receive(2000L);
                    shouldKeepIterating = this.dispatchMessage(message, (SourceCallbackContext)jmsContext.getFirst());
                }
                catch (JMSException e) {
                    LOGGER.error("[" + this.id + "] : Unknown error when trying to poll message", (Throwable)e);
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (!shouldKeepIterating) continue;
                    TransactionCoordination.getInstance().rollbackCurrentTransaction();
                }
            }
            if (this.stopRequested) {
                LOGGER.debug("[{}] : Stopping poll", (Object)this.id);
            }
            LOGGER.debug("[{}] : Finishing poll", (Object)this.id);
        }
        catch (ConnectionException e) {
            this.sourceCallback.onConnectionException(e);
        }
        catch (Exception e) {
            this.sourceCallback.onConnectionException(new ConnectionException((Throwable)e, (Object)"Unexpected error occurred trying to poll a message"));
        }
        finally {
            this.sessionManager.unbindSession();
        }
    }

    private Pair<SourceCallbackContext, JmsSession> initializePoll() throws ConnectionException, TransactionException {
        try {
            LOGGER.trace("[{}] : initializing poll ", (Object)this.id);
            SourceCallbackContext context = this.sourceCallback.createContext();
            XaJmsTransactionalConnection connect = (XaJmsTransactionalConnection)this.connectionProvider.connect();
            this.bindTransaction(context, connect);
            try {
                Pair pair = new Pair((Object)context, (Object)connect.getSession(InternalAckMode.TRANSACTED, false));
                return pair;
            }
            catch (JMSException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        finally {
            if (this.initializationCountDownLatch != null) {
                this.initializationCountDownLatch.countDown();
                this.initializationCountDownLatch = null;
            }
        }
    }

    private boolean dispatchMessage(Message message, SourceCallbackContext context) {
        if (this.stopRequested) {
            LOGGER.trace("[{}] : Stop has been requested, rolling back current transaction.", (Object)this.id);
            TransactionCoordination.getInstance().rollbackCurrentTransaction();
        } else if (message == null) {
            LOGGER.trace("[{}] : No message found, rolling back transaction.", (Object)this.id);
            TransactionCoordination.getInstance().rollbackCurrentTransaction();
        } else {
            LOGGER.trace("[{}] : received message, handling to the flow.", (Object)this.id);
            context.addVariable("CONSUMER", (Object)this);
            try {
                this.dispatcher.dispatchMessage(message, context);
                return false;
            }
            catch (Exception e) {
                LOGGER.trace("[{}] : Message dispatch failed, rolling back transaction.", (Object)this.id);
                TransactionCoordination.getInstance().rollbackCurrentTransaction();
            }
        }
        return true;
    }

    private void bindTransaction(SourceCallbackContext context, XATransactionalConnection connect) throws ConnectionException, TransactionException {
        int timesToTry = 10;
        for (int i = 1; i <= timesToTry; ++i) {
            try {
                LOGGER.trace("[{}]: about to bind connection [{}] into context: [{}]", new Object[]{this.id, connect, context});
                context.bindConnection(this.connectionProvider.connect());
                return;
            }
            catch (TransactionException e) {
                if (i == timesToTry) {
                    throw e;
                }
                LOGGER.debug("Internal error, Unable to bind transaction. trying again");
                try {
                    Field connectionField = context.getClass().getDeclaredField("connection");
                    connectionField.setAccessible(true);
                    connectionField.set(context, null);
                    continue;
                }
                catch (Exception e1) {
                    throw new MuleRuntimeException((Throwable)e1);
                }
            }
        }
    }

    public void stop() {
        this.stopRequested = true;
    }
}

