/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.connection.provider;

import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.core.api.MuleContext;

/**
 * Factory for a decorator of the {@link javax.jms.ConnectionFactory}.
 *
 * @since 1.4.0
 */
public class ConnectionFactoryDecoratorFactory {

  private final MuleContext muleContext;
  private final Registry registry;
  private final static ConnectionFactoryDecorator NULL_FACTORY_DECORATOR =
      (connectionFactory, configName, reuseSessions, username, password, clientId, exceptionListener) -> connectionFactory;

  public ConnectionFactoryDecoratorFactory(MuleContext muleContext, Registry registry) {
    this.muleContext = muleContext;
    this.registry = registry;
  }

  public ConnectionFactoryDecorator create() {
    try {
      // If the class is not found this indicates that we are not on EE and not ConnectionFactory is available.
      Class.forName("com.mulesoft.mule.runtime.bti.api.jms.ConnectionFactoryDecorator");
      return new InternalConnectionFactoryDecorator(muleContext, registry);
    } catch (ClassNotFoundException e) {
      return NULL_FACTORY_DECORATOR;
    }
  }
}
