/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection.session;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.JmsXaContext;
import org.mule.jms.commons.internal.connection.session.AckCallback;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.SessionInformation;
import org.mule.jms.commons.internal.connection.session.TransactionInformation;
import org.mule.jms.commons.internal.connection.session.TransactionStatus;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsSessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsSessionManager.class);
    private final Map<String, SessionInformation> pendingSessions = new HashMap<String, SessionInformation>();
    private final ThreadLocal<TransactionInformation> transactionInformation = new ThreadLocal();
    private final ThreadLocal<Map<XATransactionalConnection, TransactionInformation>> xaTransactions = new ThreadLocal();

    public void registerMessageForAck(String ackId, Message message, Session session, JmsListenerLock jmsLock) {
        if (!this.pendingSessions.containsKey(ackId)) {
            this.pendingSessions.put(ackId, new SessionInformation(message, session, jmsLock));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered Message for Session AckId [" + ackId + "]");
        }
    }

    public void ack(String ackId, AckCallback ackCallback) {
        Optional<SessionInformation> optionalSession = this.getSessionInformation(ackId);
        if (optionalSession.isPresent()) {
            Optional<JmsListenerLock> jmsListenerLock = optionalSession.get().getJmsListenerLock();
            if (jmsListenerLock.isPresent()) {
                jmsListenerLock.get().executeOnListenerThread(() -> {
                    try {
                        ((SessionInformation)optionalSession.get()).getMessage().acknowledge();
                        ackCallback.onSuccess();
                    }
                    catch (JMSException e) {
                        ackCallback.onError(e);
                    }
                });
            } else {
                try {
                    optionalSession.get().getMessage().acknowledge();
                    ackCallback.onSuccess();
                }
                catch (JMSException e) {
                    ackCallback.onError(e);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Acknowledged Message for Session with AckId [" + ackId + "]");
            }
        } else {
            ackCallback.onSuccess();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The session could not be acknowledged. This may be due to: \n - The session has been already acknowledged\n- The session has been recovered\n - The given 'ackId' :  [" + ackId + "] is invalid.");
            }
        }
    }

    public void recoverSession(String ackId, AckCallback ackCallback) {
        Optional<SessionInformation> optionalSession = this.getSessionInformation(ackId);
        if (optionalSession.isPresent()) {
            SessionInformation sessionInformation = optionalSession.get();
            Optional<JmsListenerLock> jmsListenerLock = sessionInformation.getJmsListenerLock();
            if (jmsListenerLock.isPresent()) {
                jmsListenerLock.get().executeOnListenerThread(() -> {
                    try {
                        ((SessionInformation)optionalSession.get()).getSession().recover();
                        ackCallback.onSuccess();
                    }
                    catch (JMSException e) {
                        ackCallback.onError(e);
                    }
                });
            } else {
                try {
                    optionalSession.get().getSession().recover();
                    ackCallback.onSuccess();
                }
                catch (JMSException e) {
                    ackCallback.onError(e);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Recovered session for AckId [ " + ackId + "]");
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The session could not be recovered, this could be due to: \n- The session has been already recovered\n- The all session messages has been already acknowledged\n- The given 'ackId' : [" + ackId + "] is invalid");
        }
    }

    private Optional<SessionInformation> getSessionInformation(String ackId) {
        return Optional.ofNullable(this.pendingSessions.remove(ackId));
    }

    public void bindToTransaction(JmsSession session) {
        this.getTransactionInformation().setJmsSession(session);
    }

    public void bindToTransaction(XATransactionalConnection jmsXaTransactionalConnection, JmsSession session, JmsXaContext xaResource) {
        TransactionInformation value = new TransactionInformation();
        value.setJmsXaContext(xaResource);
        value.setJmsSession(session);
        this.onXATransactions(transactions -> transactions.put(jmsXaTransactionalConnection, value));
    }

    public void unbindSession() {
        this.transactionInformation.remove();
        this.xaTransactions.remove();
    }

    public Optional<JmsSession> getTransactedSession(JmsConnection connection) {
        JmsSession jmsSession = this.getTransactionInformation().getJmsSession();
        if (jmsSession == null && connection instanceof XATransactionalConnection) {
            return this.getXaTransactedSession((XATransactionalConnection)connection).map(session -> session);
        }
        return Optional.ofNullable(jmsSession);
    }

    public Optional<JmsSession> getXaTransactedSession(XATransactionalConnection jmsXaTransactionalConnection) {
        Reference transactionInformationReference = new Reference();
        this.onXATransactions(transactions -> {
            TransactionInformation cfr_ignored_0 = (TransactionInformation)transactionInformationReference.set(transactions.get(jmsXaTransactionalConnection));
        });
        TransactionInformation transactionInformation = (TransactionInformation)transactionInformationReference.get();
        if (transactionInformation == null) {
            return Optional.empty();
        }
        return Optional.of(transactionInformation.getJmsSession());
    }

    public TransactionStatus getTransactionStatus() {
        TransactionStatus transactionStatus = this.getTransactionInformation().getTransactionStatus();
        return transactionStatus != null ? transactionStatus : TransactionStatus.NONE;
    }

    public void changeTransactionStatus(TransactionStatus transactionStatus) {
        this.getTransactionInformation().setTransactionStatus(transactionStatus);
    }

    private TransactionInformation getTransactionInformation() {
        TransactionInformation transactionInformation = this.transactionInformation.get();
        if (transactionInformation == null) {
            transactionInformation = new TransactionInformation();
            this.transactionInformation.set(transactionInformation);
        }
        return transactionInformation;
    }

    public Optional<JmsXaContext> getJmsXaContext(JmsTransactionalConnection xaTransactionalConnection) {
        Reference transactionInformationReference = new Reference();
        this.onXATransactions(transactions -> {
            TransactionInformation cfr_ignored_0 = (TransactionInformation)transactionInformationReference.set(transactions.get(xaTransactionalConnection));
        });
        return Optional.ofNullable(transactionInformationReference.get()).map(TransactionInformation::getJmsXaContext);
    }

    private void onXATransactions(Consumer<Map<XATransactionalConnection, TransactionInformation>> consumer) {
        Map<XATransactionalConnection, TransactionInformation> map = this.xaTransactions.get();
        if (map == null) {
            HashMap hashMap = new HashMap();
            this.xaTransactions.set(hashMap);
            consumer.accept(hashMap);
        } else {
            consumer.accept(map);
        }
    }
}

