/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.api.config;

import java.util.concurrent.TimeUnit;

import javax.jms.DeliveryMode;
import javax.jms.Message;

/**
 * Configuration parameters for sending messages to a JMS Queue or Topic
 *
 * @since 1.0
 */
public interface JmsProducerConfig {

  /**
   * Sets the default value for the {@link Message#getJMSDeliveryMode}.
   * If {@code true}, the {@link DeliveryMode#PERSISTENT} mode will be used,
   * which instructs the JMS provider to take extra care to insure the message
   * is not lost in transit due to a JMS provider failure.
   */
  public boolean isPersistentDelivery();

  /**
   * Defines the default {@link Message#getJMSPriority} to use when sending messages
   */
  public int getPriority();

  public long getTimeToLive();

  public TimeUnit getTimeToLiveUnit();

  public boolean isDisableMessageId();

  public boolean isDisableMessageTimestamp();

  public Long getDeliveryDelay();

  public TimeUnit getDeliveryDelayUnit();

  public String getJmsType();
}

