/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source;

import javax.jms.Connection;
import javax.jms.JMSException;
import org.mule.jms.commons.internal.source.JmsResourceReleaser;
import org.mule.jms.commons.internal.source.push.MessageListenerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJmsResourceReleaser
implements JmsResourceReleaser {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @Override
    public final void releaseConnection(Connection connection) {
        try {
            this.doCleanConnection(connection);
        }
        catch (Exception e) {
            this.LOGGER.warn(String.format("An exception was raised when cleaning the JMS Connection [%s]:", connection.getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public void releaseConsumerMessageListener(MessageListenerContext info) {
        try {
            info.getConsumer().listen(null);
        }
        catch (JMSException e) {
            this.LOGGER.error(String.format("An unexpected error occurred trying to turn off a MessageListener [%s].", info.getConsumer()), (Throwable)e);
        }
    }

    protected void doCleanConnection(Connection connection) {
    }
}

