/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.operation.publishconsume;

import javax.jms.CompletionListener;
import javax.jms.Message;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.publish.JmsMessageProducer;
import org.mule.runtime.api.scheduler.Scheduler;

public class ResourceCloserCompletionListener
implements CompletionListener {
    private CompletionListener delegate;
    private JmsSession producerSession;
    private AutoCloseable producer;
    private final Scheduler scheduler;

    public ResourceCloserCompletionListener(CompletionListener delegate, JmsSession jmsSession, JmsMessageProducer producer, Scheduler scheduler) {
        this.delegate = delegate;
        this.producerSession = jmsSession;
        this.producer = producer;
        this.scheduler = scheduler;
    }

    public void onCompletion(Message message) {
        this.scheduler.submit(this.closeResources());
        this.delegate.onCompletion(message);
    }

    public void onException(Message message, Exception exception) {
        this.scheduler.submit(this.closeResources());
        this.delegate.onException(message, exception);
    }

    private Runnable closeResources() {
        return () -> {
            JmsCommons.closeQuietly(this.producer);
            JmsCommons.closeQuietly(this.producerSession);
        };
    }
}

