/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.api.connection.factory.jndi;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.mule.jms.commons.api.connection.factory.jndi.JndiNameResolver;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractJndiNameResolver
implements JndiNameResolver {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String jndiProviderUrl;
    private String jndiInitialFactory;
    private Map<String, Object> jndiProviderProperties;
    private InitialContextFactory contextFactory = InitialContext::new;

    AbstractJndiNameResolver() {
    }

    protected Context createInitialContext() throws NamingException {
        return this.contextFactory.getInitialContext(this.getContextProperties());
    }

    protected Hashtable getContextProperties() {
        Preconditions.checkArgument((this.jndiInitialFactory != null ? 1 : 0) != 0, (String)"Undefined value for jndiInitialFactory property");
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("java.naming.factory.initial", this.jndiInitialFactory);
        if (this.jndiProviderUrl != null) {
            props.put("java.naming.provider.url", this.jndiProviderUrl);
        }
        if (this.jndiProviderProperties != null) {
            props.putAll(this.jndiProviderProperties);
        }
        return props;
    }

    public String getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.jndiProviderUrl = jndiProviderUrl;
    }

    public String getJndiInitialFactory() {
        return this.jndiInitialFactory;
    }

    public void setJndiInitialFactory(String jndiInitialFactory) {
        this.jndiInitialFactory = jndiInitialFactory;
    }

    public Map<String, Object> getJndiProviderProperties() {
        return this.jndiProviderProperties;
    }

    public void setJndiProviderProperties(Map<String, Object> jndiProviderProperties) {
        this.jndiProviderProperties = jndiProviderProperties;
    }

    public InitialContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(InitialContextFactory contextFactory) {
        if (contextFactory == null) {
            throw new IllegalArgumentException("Context factory cannot be null");
        }
        this.contextFactory = contextFactory;
    }

    public void initialise() throws InitialisationException {
    }

    public void dispose() {
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }
}

