/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Supplier;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.transaction.xa.XAResource;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.JmsXaContext;
import org.mule.jms.commons.internal.connection.exception.CompositeJmsExceptionListener;
import org.mule.jms.commons.internal.connection.session.DefaultJmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.tx.MuleXaObject;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XaJmsTransactionalConnection
extends JmsTransactionalConnection
implements XATransactionalConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(XaJmsTransactionalConnection.class);
    private static Supplier<Method> getXAResourceMethod;

    public XaJmsTransactionalConnection(JmsSupport jmsSupport, Connection connection, JmsSessionManager jmsSessionManager, CompositeJmsExceptionListener exceptionListener) {
        super(jmsSupport, connection, jmsSessionManager, exceptionListener);
    }

    public XAResource getXAResource() {
        Optional<JmsXaContext> optionalJmsXaContext = this.getJmsSessionManager().getJmsXaContext(this);
        if (optionalJmsXaContext.isPresent()) {
            return optionalJmsXaContext.get().getXaResource();
        }
        try {
            Session session = this.getJmsSupport().createSession(this.get(), false, true, InternalAckMode.TRANSACTED.getAckModeValue());
            session.createMessage();
            XAResource xaResource = this.getXAResource((MuleXaObject)session);
            this.getJmsSessionManager().bindToTransaction(this, new DefaultJmsSession(session), new JmsXaContext(xaResource));
            return xaResource;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private XAResource getXAResource(MuleXaObject session) throws IllegalAccessException, InvocationTargetException {
        return (XAResource)getXAResourceMethod.get().invoke(session.getTargetObject(), new Object[0]);
    }

    public JmsSession getSession(InternalAckMode ackMode, boolean isTopic) throws JMSException {
        Optional<JmsSession> transactedSession = this.getJmsSessionManager().getXaTransactedSession(this);
        if (transactedSession.isPresent()) {
            return transactedSession.get();
        }
        return this.createSession(ackMode, isTopic);
    }

    public void close() {
        this.getJmsSessionManager().getTransactedSession(this).ifPresent(JmsCommons::closeQuietly);
        this.getJmsSessionManager().getJmsXaContext(this).ifPresent(jmx -> {
            try {
                jmx.end();
            }
            catch (Throwable t) {
                LOGGER.warn("Exception found while stopping Jms XA Context", t);
            }
        });
        this.getJmsSessionManager().unbindSession(this);
    }

    static {
        try {
            Class<?> aClass = ExtensionManager.class.getClassLoader().loadClass("bitronix.tm.resource.jms.DualSessionWrapper");
            getXAResourceMethod = new LazyValue((Object)aClass.getMethod("getXAResource", new Class[0]));
        }
        catch (Exception e) {
            getXAResourceMethod = () -> {
                throw new MuleRuntimeException((Throwable)e);
            };
        }
    }
}

