/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.api;

import javax.jms.JMSException;
import javax.jms.Message;

/**
 * Enum which list the available Request Reply Patterns supported by the JMS Client
 *
 * @since 1.6.0
 */
public enum RequestReplyPattern {

  CORRELATION_ID {

    public String createSelector(Message message) throws JMSException {
      return "JMSCorrelationID = '" + message.getJMSCorrelationID() + "'";
    }
  },

  MESSAGE_ID {

    public String createSelector(Message message) throws JMSException {
      return "JMSCorrelationID = '" + message.getJMSMessageID() + "'";
    }
  },

  NONE;

  private static final String EMPTY_SELECTOR = "";

  public String createSelector(Message message) throws JMSException {
    return EMPTY_SELECTOR;
  }
}
