/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source;

import javax.jms.Connection;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.source.JmsResourceReleaser;
import org.mule.jms.commons.internal.source.push.MessageListenerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJmsResourceReleaser
implements JmsResourceReleaser {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @Override
    public final void releaseConnection(Connection connection) {
        try {
            this.doCleanConnection(connection);
        }
        catch (Exception e) {
            this.LOGGER.warn(String.format("An exception was raised when cleaning the JMS Connection [%s]:", connection.getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public void releaseConsumerMessageListener(MessageListenerContext info) {
        JmsCommons.closeQuietly(info.getConsumer());
    }

    protected void doCleanConnection(Connection connection) {
    }
}

