/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.configuration;

import static java.util.concurrent.TimeUnit.MINUTES;
import static org.mule.runtime.extension.api.annotation.param.display.Placement.ADVANCED_TAB;

import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;

/**
 * Base class for configuration objects
 *
 * @since 1.0
 */
public abstract class RestConnectConfiguration implements Initialisable {

  @DefaultEncoding
  private String defaultEncoding;
  private Charset charset;

  /**
   * The timeout for request to the remote service. This value is qualified by
   * the {@link #responseTimeoutUnit}
   */
  @Parameter
  @Optional(defaultValue = "1")
  @Placement(tab = ADVANCED_TAB)
  @Summary("The timeout for request to the remote service.")
  private Integer responseTimeout;

  /**
   * A time unit which qualifies the {@link #responseTimeout}
   */
  @Parameter
  @Optional(defaultValue = "MINUTES")
  @Placement(tab = ADVANCED_TAB)
  @Summary("A time unit which qualifies the Response Timeout}")
  private TimeUnit responseTimeoutUnit = MINUTES;

  /**
   * Defines if the request should be sent using streaming or not.
   * Setting the value to AUTO will automatically define the best strategy based on the request content.
   * As streaming is done the request will be sent user Transfer-Encoding: chunked.
   */
  @Parameter
  @Placement(tab = ADVANCED_TAB)
  @Optional(defaultValue = "AUTO")
  @Summary("Defines if the request should be sent using streaming. "
      + "Setting the value to AUTO will automatically define the best strategy based on the request content.")
  private StreamingType streamingType;

  @Override
  public void initialise() {
    charset = Charset.forName(defaultEncoding);
  }

  public Charset getCharset() {
    return charset;
  }

  public Integer getResponseTimeout() {
    return responseTimeout;
  }

  public TimeUnit getResponseTimeoutUnit() {
    return responseTimeoutUnit;
  }

  public StreamingType getStreamingType() {
    return streamingType;
  }
}
