/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.configuration;

/**
 * Streaming mode for HTTP. Streaming in HTTP implies using Transfer-Encoding: chunked
 *
 * @since 1.0
 */
public enum StreamingType {
  /**
   * Will automatically define the best strategy based on the request content.
   */
  AUTO,
  /**
   * Will always use streaming.
   */
  ALWAYS,
  /**
   * Will never use streaming.
   */
  NEVER
}
