/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.internal.util;

import static java.util.regex.Pattern.compile;

import java.util.regex.Pattern;

public class DwUtils {

  private DwUtils() {}

  private final static Pattern dwInvalidChars = compile("[^a-zA-Z0-9_]");

  public static String getDwIdentifier(String name) {
    while (dwInvalidChars.matcher(name).find()) {
      name = dwInvalidChars.matcher(name).replaceAll("_");
    }

    return "dw" + name;
  }
}
