/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.restconnect.commons.internal.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.util.IOUtils;

public final class RestConnectUtils {
    private RestConnectUtils() {
    }

    public static void closeAndRelease(CursorProvider cursorProvider) {
        cursorProvider.close();
        cursorProvider.releaseResources();
    }

    public static void closeStream(Object stream) {
        if (stream instanceof CursorProvider) {
            RestConnectUtils.closeAndRelease((CursorProvider)stream);
        } else if (stream instanceof InputStream) {
            IOUtils.closeQuietly((Closeable)((InputStream)stream));
        }
    }

    public static TypedValue<String> consumeStringAndClose(Object stream, MediaType targetMediaType, Charset targetCharset) {
        return RestConnectUtils.consumeStringTransformAndClose(stream, targetCharset, targetMediaType, targetCharset);
    }

    public static TypedValue<String> consumeStringTransformAndClose(Object stream, Charset sourceCharset, MediaType targetMediaType, Charset targetCharset) {
        Either content;
        if (stream == null) {
            return RestConnectUtils.toTypedValue("", targetMediaType, targetCharset);
        }
        if (stream instanceof String) {
            return RestConnectUtils.toTypedValue((String)stream, targetMediaType, targetCharset);
        }
        if (stream instanceof CursorStreamProvider) {
            content = Either.left((Object)((CursorStreamProvider)stream));
        } else if (stream instanceof InputStream) {
            content = Either.right((Object)((InputStream)stream));
        } else {
            throw new IllegalArgumentException("Cannot consume stream of unsupported type: " + stream.getClass().getName());
        }
        return (TypedValue)content.reduce(provider -> {
            try {
                TypedValue<String> typedValue = RestConnectUtils.doConsumeAndClose((InputStream)provider.openCursor(), sourceCharset, targetMediaType, targetCharset);
                return typedValue;
            }
            finally {
                RestConnectUtils.closeAndRelease((CursorProvider)provider);
            }
        }, in -> RestConnectUtils.doConsumeAndClose(in, sourceCharset, targetMediaType, targetCharset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypedValue<String> doConsumeAndClose(InputStream stream, Charset sourceCharset, MediaType targetMediaType, Charset targetCharset) {
        try {
            TypedValue<String> typedValue = RestConnectUtils.toTypedValue(IOUtils.toString((InputStream)stream, (Charset)sourceCharset), targetMediaType, targetCharset);
            return typedValue;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    private static TypedValue<String> toTypedValue(String value, MediaType mediaType, Charset encoding) {
        return new TypedValue((Object)value, DataType.builder().mediaType(mediaType).charset(encoding).build());
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean containsIgnoreCase(String value, String predicate) {
        if (value == null || predicate == null) {
            return false;
        }
        return value.toLowerCase().contains(predicate.toLowerCase());
    }

    public static boolean isNotBlank(String v) {
        return v != null && v.trim().length() > 0;
    }

    public static String readSchema(ClassLoader classLoader, String schemaPath) {
        String schema;
        if (schemaPath.startsWith("/")) {
            schemaPath = schemaPath.substring(1);
        }
        try (InputStream in = classLoader.getResourceAsStream(schemaPath);){
            if (in == null) {
                throw new IllegalArgumentException("Could not find schema at " + schemaPath);
            }
            schema = IOUtils.toString((InputStream)in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return schema;
    }

    public static MetadataType loadXmlSchema(String schemaPath, String schemaContent, String qName) {
        SchemaCollector schemaCollector = SchemaCollector.getInstance().addSchema(schemaPath, (InputStream)new ByteArrayInputStream(schemaContent.getBytes()));
        Optional metadataType = new XmlTypeLoader(schemaCollector).load(qName);
        if (!metadataType.isPresent()) {
            throw new RuntimeException("Could not load XML Schema " + schemaPath + " QName:" + qName);
        }
        return (MetadataType)metadataType.get();
    }

    public static MetadataType loadJsonSchema(String schemaPath, String schemaContent, MetadataFormat metadataFormat) {
        Optional optionalMetadataType = new JsonTypeLoader(schemaContent).load(null);
        if (!optionalMetadataType.isPresent()) {
            throw new RuntimeException("Could not load Json Schema " + schemaPath);
        }
        MetadataType metadataType = (MetadataType)optionalMetadataType.get();
        try {
            RestConnectUtils.setMetadataFormat(metadataType, metadataFormat);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Could not set MetadataFormat to MetadataType", e);
        }
        return metadataType;
    }

    private static void setMetadataFormat(MetadataType metadataType, MetadataFormat newMetadataFormat) throws NoSuchFieldException, IllegalAccessException {
        Field metadataFormatField = BaseMetadataType.class.getDeclaredField("metadataFormat");
        metadataFormatField.setAccessible(true);
        metadataFormatField.set(metadataType, newMetadataFormat);
    }
}

