/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.connection;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

/**
 * Base class for connection providers which use basic authentication
 *
 * @since 1.0
 */
public abstract class BasicAuthenticationConnectionProvider extends BaseConnectionProvider {

  /**
   * The username to authenticate the requests
   */
  @Parameter
  @Optional
  @Summary("The username to authenticate the requests")
  protected String username;

  /**
   * The password to authenticate the requests
   */
  @Parameter
  @Optional
  @Summary("The password to authenticate the requests")
  @Password
  protected String password;

  @Override
  protected HttpAuthentication buildAuthentication() {
    return HttpAuthentication.basic(username, password).build();
  }
}
