/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.connection;

import org.mule.runtime.http.api.client.auth.HttpAuthentication;

/**
 * Base class for connection providers secured through the digest security scheme
 *
 * @since 1.0
 */
public abstract class DigestConnectionProvider extends BasicAuthenticationConnectionProvider {

  @Override
  protected HttpAuthentication buildAuthentication() {
    return HttpAuthentication.digest(username, password).build();
  }
}
