/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.connection.validation;

/**
 * This object represents a condition to be met by a server response in order to consider a connection valid.
 *
 * @since 1.0
 */
public class TestConnectionValidation {

  private final String validationExpression;
  private final String errorTemplateExpression;

  public TestConnectionValidation(String validationExpression, String errorTemplateExpression) {
    this.validationExpression = validationExpression;
    this.errorTemplateExpression = errorTemplateExpression;
  }

  public String getValidationExpression() {
    return validationExpression;
  }

  public String getErrorTemplateExpression() {
    return errorTemplateExpression;
  }
}
