/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.internal.util;

import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

/**
 * Base class for a {@link CompletionCallback} decorator
 *
 * @param <T> the generic payload type
 * @param <A> the generic attributes type
 */
public abstract class CompletionCallbackDecorator<T, A> implements CompletionCallback<T, A> {

  private final CompletionCallback<T, A> delegate;

  public CompletionCallbackDecorator(CompletionCallback<T, A> delegate) {
    this.delegate = delegate;
  }

  @Override
  public void success(Result<T, A> result) {
    delegate.success(result);
  }

  @Override
  public void error(Throwable throwable) {
    delegate.error(throwable);
  }
}
