/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.internal.util;

import static org.mule.runtime.api.connection.ConnectionValidationResult.failure;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;

/**
 * Utils class for validating connections
 *
 * @since 1.0
 */
public final class ConnectionValidationUtils {

  private ConnectionValidationUtils() {}

  /**
   * Generates a failed {@link ConnectionValidationResult}.
   * This validation result cause will be a {@link ConnectionException} with the indicated message set.
   * @param message The {@link ConnectionException} message
   * @return a failed connection validation result.
   */
  public static ConnectionValidationResult connectionExceptionResult(String message) {
    return connectionExceptionResult(message, null);
  }

  /**
   * Generates a failed {@link ConnectionValidationResult}.
   * This validation result cause will be a {@link ConnectionException} with the indicated message set.
   * @param message the {@link ConnectionException} message.
   * @param cause   the {@link ConnectionException} cause.
   * @return a failed connection validation result.
   */
  public static ConnectionValidationResult connectionExceptionResult(String message, Throwable cause) {
    return connectionValidationResult(new ConnectionException(message, cause));
  }

  /**
   * Generates a failed {@link ConnectionValidationResult}.
   * @param e this will be te cause of the validation result failing.
   * @return a failed connection validation result.
   */
  public static ConnectionValidationResult connectionValidationResult(Exception e) {
    return failure("Test connection failed", e);
  }
}
